/* Yuck, another header with code in it.  This is printf emulation in 
 * graphics modes.  -- gfoot */

/* public */

#include <stdarg.h>

#define printf gfx_printf
#define fflush(stream)

void init_gfx_printf (void);
int gfx_printf (const char *format, ...);


/* private */

int gfx_printf_x, gfx_printf_y;

void init_gfx_printf (void)
{
	gfx_printf_x = 0;
	gfx_printf_y = 0;
}

void gfx_printf_scroll (void)
{
	gfx_printf_y += 8;
	if (gfx_printf_y > 472) {
		int y;
		BITMAP *temp_buffer = create_bitmap (640, 8);
		gfx_printf_y -= 8;
		for (y = 0; y <= gfx_printf_y; y += 8) {
			acquire_screen();
			blit (screen, temp_buffer, 0, y+8, 0, 0, 640, 8);
			blit (temp_buffer, screen, 0, 0, 0, y, 640, 8);
			release_screen();
		}
		acquire_screen();
		rectfill (screen, 0, gfx_printf_y, 639, 479, 0);
		release_screen();
	}
}

void gfx_printchar (char ch)
{
	switch (ch) {
		case '\n':
			gfx_printf_scroll();
		case '\r':  /* fall through */
			gfx_printf_x = 0;
			break;
		default:
			{
				char buffer[2];
				buffer[0] = ch;
				buffer[1] = '\0';
				acquire_screen();
				textout (screen, font, buffer, gfx_printf_x, gfx_printf_y, makecol(255, 255, 255));
				release_screen();
				gfx_printf_x += 8;
				if (gfx_printf_x > 632) {
					gfx_printf_scroll();
					gfx_printf_x = 0;
				}
			}
			break;
	}
}

void gfx_printline (const char *s)
{
	while (*s) gfx_printchar (*s++);
}

int gfx_printf (const char *format, ...)
{
	va_list args;
	static char buffer[1024];
	int val;
	
	va_start (args, format);
	val = vsprintf (buffer, format, args);
	va_end (args);
	
	gfx_printline (buffer);
	
	return val;
}
