//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#include "Itana.h"
#include "itanadat.h"
#include "ZylexShip.h"
#include "Vector.h"
#include "Video.h"
#include "ZylexBullet.h"
#include "Game.h"
#include "ShipStats.h"
#include "Sound.h"
#include "MovingEffect.h"
#include "Console.h"

//The Zylex ship has three powerful engines.
//(0, 15), (1, 4), (1,27)
const int NUM_ENGINES = 3;
const Vector engines[NUM_ENGINES] = {Vector(-15,0), Vector(-14, -11), Vector(-14, 12)};

const double BLASTER_RECOIL = 0.6;

ZylexShip::ZylexShip() {
  type = ZYLEX_STATS;
  id = ID_ZYLEX_SHIP;
  currEngine = 0;
}

void ZylexShip::init(const Rect& rect, const Vector& vect) {
  Ship::init(rect, vect);
}

void ZylexShip::input() {
  Ship::input();
}

bool ZylexShip::update() {
  return Ship::update();
}

void ZylexShip::draw() {
  if (!dead) {
    Video::drawSprite(GRFX_DAT_ZYLSHIP_BMP, loc, scrLoc, radToFix(theta));
    Ship::draw();
  }
}

void ZylexShip::fire(int dir) {
  //Zylex ships fire a blaster
  if (energy >= STATS[type].fireuse) {
    if (normalReload == 0) {
      Sound::playMapSound(SFX_DAT_ZYLLAZ_WAV, loc.getCenter());
      Ship::fire(new ZylexBullet(loc.getCenter(), vect, theta), theta + PI, BLASTER_RECOIL);
      energy -= STATS[type].fireuse;
      normalReload = STATS[type].firedelay;
    }
    actions |= FIREUP;
  }
}

void ZylexShip::special() {
  //Zylex special ability is to go through asteroids.
  //This is handled in Ship::doCollision
  //Display a message alerting the user if he presses the special button
  if (specialReload == 0) {
    console->addLine("The Zylex ship goes through asteroids without the usage of the");
    console->addLine(" special button being pressed -- it is always active.");
    specialReload = STATS[type].specialdelay;
  }
}

void ZylexShip::throwEngineParticle(const Vector& partVect) {
  if ((Game::getFrame() % 2) == 0) {
    Vector temp = engines[currEngine];
    currEngine++;
    if (currEngine >= NUM_ENGINES)
      currEngine = 0;

    temp.rotate(theta);
    double midx = loc.x + loc.w/2;
    double midy = loc.y + loc.h/2;
    FadeParticle* newParticle = new FadeParticle(Point(midx + temp.getMagx(), midy + temp.getMagy()),
                                                 200, partVect, 255, 192, 128);
    Game::moveEffect(newParticle);
  }
}