//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#ifndef _VIDEO_H_
#define _VIDEO_H_

#include "Itana.h"
class Rect;
#include "IntRect.h"
class Interface;
class Radar;
class Stars;

//The Video class abstracts all drawing functions.  Nothing else in Itana
//should directly use Allegro drawing functions or assume a platform.
//The only exception to this rule is the front end (pre game).

const double MAP_SIZE = 8192.0;
const int scrx = 800;
const int scry = 600;

struct Pixel {
  int x, y, color;
  Pixel(int x2, int y2, int color2) : x(x2), y(y2), color(color2) {}
};

class Video {
public:
  static void construct(); //CONSTRUCTOR DOES NOT PROPERLY INITALIZE THIS CLASS
  static void destruct();
  
  static void init(DATAFILE* datafileRoot);
    //initalize the Video class
  static void initVideo();
    //initalize for the game mode (clipping/blenders)
  static void setupGameMouse();
    //sets up the mouse for the game
  static void setupGUIMouse();
    //Sets up the mouse for the GUI

  static int  getDepth();//returns current color depth
  static Rect getView(); //a map rectangle of the current view
  static bool setVideoMode();
    //sets the video mode, returns true on error.

  static void setAddBlender();
    //sets transparency to additive mode.  You MUST return to default mode
    //when you are done drawing
  static void setDefaultBlender();
    //sets blending to default mode.

  static void drawRLESprite(int idx, IntRect rect);
  static void drawSprite(int idx, const IntRect& realrect, const IntRect& vidrect, fixed theta);
  static void drawSprite(BITMAP* bmp, IntRect realrect, const IntRect& vidrect, fixed theta);
  static void drawTransSprite(int idx, IntRect realrect, const IntRect& vidrect, fixed theta);
    //realrect contains the map x, y, width, and height for the object.
    //vidrect contains offset x and y and big width and height for a rect
    //which will hold all possible area the rotated sprite can contain
  static void drawTransSprite(BITMAP* bmp, IntRect rect);
  static void drawDot(IntPoint point, int color);//adjusts for view
  static void drawTransDot(IntPoint point, int color);//adjusts for view
  static void drawStar(int x, int y, int color); //does not adjust for view
    //optimized for a single pixel
  static void drawMapText(IntRect rect, int color, const char* format, ...);
    //prints text on the map with the default font
    //rects w,h need not be defined (this funciton uses them internally)
  static void drawText(IntRect rect, int color, const char* format, ...);
    //prints text at an absolute position on the screen.
  static void drawTransCircle(IntPoint point, int radius, int color);
    //Draws a additively blended circle (for explosions)

  static void addNoClearRect(const IntRect& rect);
  static void addRect(const IntRect& rect);
    //both used by interface and radar only!

  static void showMouse(bool shown);
    //true if mouse is on, false if off

  static void dirtyAll() {blitAll = true;} //force a full refresh

  static void setView(const IntPoint& center, Stars* stars);
    //point to be centered on, stars to be updated with difs
  static void update(Interface* statusbar, Radar* radar);
    //Draws the mouse cursor if shown and updates dest
    //stausbar and radar do their own drawing

private:
  static int depth;         //The current color depth
  static BITMAP* buffer;    //the local memory buffer
  //static BITMAP* guiMouse;  //Converted bitmap for the GUI's mouse.
  static DATAFILE* sprites; //graphics data
  static Interface* bar;    //the interface

  static int viewx, viewy;  //viewpoints

  static LinkList<Pixel> oldPixels;  //Special one-pixel rect cases. This is beneficial for our
  static LinkList<Pixel> newPixels;  //many calculations on rects when we have several hundred stars
                              //and only a very small number of "real rects"

  static IntRect* noClearRects;        //Rects that don't clear
  static int numNoClearRects;

  static IntRect* oldRects;            //an "old list" of clears
  static int numOldRects;
  static IntRect* newRects;            //For dirty rectangling
  static int numNewRects;              //number of rects currently stored
  static LinkList<IntRect> optRects;   //finalized(optimized) rectanges to copy to screen

  static bool blitAll;                 //if true then the whole screen is dirty

  static void installCallbacks();      //Sets up multitasking callbacks/props
  static bool tryDepth(int depth);     //attempts a color depth

  //Drawing functions
  static void snowball(const IntRect& rect);
    //used by optimizeRects to add to optRects using snowball algor
  static void optimizeRects();
  static void doClears();         //clears on buffer, not screen
  static void clearPixels();
  static void updateAll(Interface* statusbar, Radar* radar);
  static void updateNoClearRects();
  static void updatePixels();          //draw to screen
  static void updateOptRects();

  static IntRect mouseRect;            //the rectangle the mouse occupies
  static bool mouse;                   //is the mouse on the screen?
  static void drawMouse();
  static void drawEdges();             //draws the edges of the map
};

#endif