//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#include "Itana.h"
#include "Vector.h"

void Vector::initRect(double magx2, double magy2) {
  magx = magx2;
  magy = magy2;
  theta = atan2(magy, magx);
  if (magy)
    mag = magy / sin(theta);
  else
    mag = fabs(magx);
}

void Vector::initPolar(double theta2, double mag2) {
  theta = theta2;
  mag = mag2;
  magy = mag * sin(theta);
  magx = mag * cos(theta);
}

void Vector::rotate(double rotation) {
  theta += rotation;
  magy = mag * sin(theta);
  magx = mag * cos(theta);
}

void Vector::add(const Vector& other) {
  //Vector addition
  initRect(magx+other.magx, magy+other.magy);
}

void Vector::add(double scalar) {
  mag += scalar;
  magy = mag * sin(theta);
  magx = mag * cos(theta);
}

void Vector::clip(double max) {
  //Adds to total magnitude
  if (mag > max) {
    mag = max;
    magy = mag * sin(theta);
    magx = mag * cos(theta);
  }
}
/*
void Vector::clipTheta(double newTheta, double tolerance) {
  if (theta != newTheta) {
    if (abs(theta - newTheta) < tolerance)
      theta = newTheta;
      magy = mag * sin(theta);
      magx = mag * cos(theta);
  }
}
*/
void Vector::mult(double scalar) {
  //multiplies to total magnitude
  mag *= scalar;
  magy = mag * sin(theta);
  magx = mag * cos(theta);
}