//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#ifndef _STAR_H_
#define _STAR_H_

#include "Itana.h"
#include "IntRect.h"
#include "Video.h"

//the Stars class actually manages all of the stars and is closely tied in
//with the video class since star's positions are "faked," otherwise every
//star's location and depth would have to be stored!  So instead simply as
//we move we delete stars off the screen and in turn create stars where the
//view is headed

struct Star {
  double x;
  double y;
  double dist; //This is a fraction 0..1 to be multiplied an offset
};

class Stars {
public:
  Stars();
  ~Stars();

  void init(); //reinitalizes all of the stars
  void update(double dx, double dy); //a "screen move" of dx, dy
  void draw(); //draws all stars

private:
  Star* stars;
};

#endif