//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#include "Itana.h"
#include "Star.h"
#include "Video.h"

//the main statusbar area above is 48 pixels tall
//this is the viewport on the PHYSICAL screen not the map!
const int BAR_HEIGHT = 48;
const IntRect viewport(0, BAR_HEIGHT, scrx, scry-BAR_HEIGHT);
const double STAR_DIST_MIN = 0.7;
const double STAR_DIST_MAX = 0.2;

const int NUM_STARS = 150;

Stars::Stars() {
  stars = new Star[NUM_STARS];
}

Stars::~Stars() {
  delete[] stars;
}

void Stars::init() {
  //reinitalizes all of the stars
  for (int c=0; c<NUM_STARS; c++) {
    stars[c].x = getrndd(scrx-1);
    stars[c].y = getrndd(scry-1);
    stars[c].dist = getrndd(STAR_DIST_MIN, STAR_DIST_MAX);
  }
}

void Stars::update(double dx, double dy) {
  //a "screen move" of dx, dy
  for (int c=0; c<NUM_STARS; c++) {
    stars[c].x += dx * stars[c].dist;
    stars[c].y += dy * stars[c].dist;
    while (stars[c].x < viewport.x)
      stars[c].x += viewport.w-1;
    while (stars[c].x > viewport.x+viewport.w-1)
      stars[c].x -= viewport.w-1;
    while (stars[c].y < viewport.y)
      stars[c].y += viewport.h-1;
    while (stars[c].y > viewport.y+viewport.h-1)
      stars[c].y -= viewport.h-1;
  }
}

void Stars::draw() {
  //draws all stars
  for (int c=0; c<NUM_STARS; c++) {
    int color = int((stars[c].dist+STAR_DIST_MAX) * 255.0);
    Video::drawStar((int)stars[c].x, (int)stars[c].y,
                    makecol(color, color, color));
  }
}