//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#ifndef _SHIP_H_
#define _SHIP_H_

#include "Itana.h"
#include "MovingEntity.h"
class Base;
class Interface;
class Bullet;
#include "PacketConsts.h"

const int   CTRL_LOCAL    = 0;  //client side controls
const int   CTRL_AI       = 1;
const int   CTRL_SERVER   = 2;  //set if object is server-side
const int   CTRL_NET      = 16; //add player # to this
const int   HUMAN_STATS   = 0;
const int   ZYLEX_STATS   = 1;
const int   ORNON_STATS   = 2;
const int   ALSETTI_STATS = 3;

const int LEFT = 0;
const int RIGHT = 1;
const int UP = 2;
const int DOWN = 3;

class Ship : public MovingEntity {
public:
  void init(const Rect& rect, const Vector& vect2);
  void bind(int ctrl) { control = ctrl; } //bind input source
  void bindBase(Base* base) { myBase = base; } //bind to base
  Base* getMyBase() { return myBase; }   //used in network
  bool isDead() { return dead; }
  bool isCloaked() {return (actions & CLOAKED) != 0;}

  void updateStats(Interface* statusbar);//updates the status bar for this ship
  void respawn();                        //respawns near base

  void doCollision(Entity* other);

  //Networking functions
  Packet* makePacket(); //Makes a packet of an approprate type
  void    usePacket(Packet* packet);
  void    makeObsolete() {obsolete = true;} //player leaves
    //if the packet is of the right type, update this object, else do nothing

  virtual void input();
          void localInput();
          void netInput();
          void AIInput();
  virtual bool update();
  virtual void draw();

  void getRepaired(int energy2, int shield2, int armor2);
    //Base calls this on its dockee to repair it

protected:
  Ship() {}

  int type;                        //ship type, for usage in stats
  int energy, shield, armor, score;//current stats
  bool dead, obsolete;             //ship status
  int paralized;
  int normalReload, specialReload; //weapon status
  Base* myBase;
  int control;
  double turret; //turret angle, for select ships
  Actions actions;

  //Controls
  void turn(bool cw, int slow);//true if ship is turning clockwise/slowly
  void turnTurret(double change) {turret += change;}
  void accel(bool fast);//if fast == true then afterburn
  void eToS();//energy to shields
  void sToE();//shields to energy
  void dock();//attempts to dock to base

  //Weapons
  void fire(Bullet* bull, double recoilTheta, double recoilMag);
  virtual void fire(int dir) = 0;
  virtual void special() = 0;

  //cosmetics
  void paralize(int time); //paralizes this ship for time frames
  void die(); //create explosions and sounds, this also performs nessacary code
  void createEngineParticle(bool aburn);
  virtual void throwEngineParticle(const Vector& partVect) = 0;
};

#endif