//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#include "Itana.h"
#include "Radar.h"
#include "IntRect.h"
#include "Prefs.h"
#include "Video.h"
#include "Game.h"
#include "Ship.h"

const IntRect RADAR_AREA(656, 16, 128, 128);
const IntRect BIGRADAR_AREA(240, 100, 320, 200);

const double ZOOMFACTOR = 32.0;
  //the radar's total area is 128*20 wide and 128*20 tall

const double GRIDSIZE = 256.0;
  //every 256 units appears a grid line (yeah!)

Radar::Radar() {
  radar = bigRadar = NULL;
}

void Radar::init() {
  if (radar)
    destroy_bitmap(radar);
  if (bigRadar)
    destroy_bitmap(bigRadar);
  radar = create_bitmap(RADAR_AREA.w, RADAR_AREA.h);
  bigRadar = create_bitmap(BIGRADAR_AREA.w, BIGRADAR_AREA.h);
  clear(radar);
  clear(bigRadar);
  radarCleared = bigRadarCleared = true;
  bigRadarOn = false;
  radarLoc.x = radarLoc.y = 0.0;
}

Radar::~Radar() {
  if (radar)
    destroy_bitmap(radar);
  if (bigRadar)
    destroy_bitmap(bigRadar);
}

void Radar::setCenter(const Point& loc) {
  radarLoc.x = loc.x;
  radarLoc.y = loc.y;
}

void Radar::input() {
  if (key[prefs->c_bigradar])
    bigRadarOn = true;
  else
    bigRadarOn = false;
}

void Radar::update() {
  //Get ready to draw
  if (bigRadarOn && !bigRadarCleared)
    clear(bigRadar);
  if (!radarCleared)
    clear(radar);
}

void Radar::draw(BITMAP* dest) {
  //can be called multiple times for many lists
  if (bigRadarOn) {
    render(bigRadar);
    bigRadarCleared = false;
    blit(bigRadar, dest, 0, 0, BIGRADAR_AREA.x, BIGRADAR_AREA.y, BIGRADAR_AREA.w, BIGRADAR_AREA.h);
    Video::addRect(BIGRADAR_AREA);
    rectfill(dest, RADAR_AREA.x, RADAR_AREA.y, RADAR_AREA.getRight(), RADAR_AREA.getBottom(), 0);
    Video::addNoClearRect(RADAR_AREA);
  } else {
    render(radar);
    radarCleared = false;
    blit(radar, dest, 0, 0, RADAR_AREA.x, RADAR_AREA.y, RADAR_AREA.w, RADAR_AREA.h);
    Video::addNoClearRect(RADAR_AREA);
  }
}

void Radar::render(BITMAP* bmp) {
  drawGrid(bmp);
  LinkList<MovingEntity>* mEnts = Game::getMovingEntities();
  LinkList<Entity>* oEnts = Game::getOrbitingEntities();
  mEnts->SetToStart();
  int l = mEnts->Length();
  int c;
  for (c=0; c<l; c++) {
    drawEntity(mEnts->_GetNext(), bmp);
    mEnts->_Advance();
  }
  oEnts->SetToStart();
  l = oEnts->Length();
  for (c=0; c<l; c++) {
    drawEntity(oEnts->_GetNext(), bmp);
    oEnts->_Advance();
  }
}

void Radar::drawGrid(BITMAP* bmp) {
  const double interval = GRIDSIZE/ZOOMFACTOR;
  double dummy, x, y;
  double start = bmp->w/2 + (GRIDSIZE - modf(radarLoc.x/GRIDSIZE, &dummy) * GRIDSIZE) / ZOOMFACTOR;
  //grid is center-based, so draw left, then right, of the start point
  for (x = start; x > 0; x -= interval)
    vline(bmp, (int)x, 0, bmp->h, makecol(96, 96, 96));
  for (x = start; x < bmp->w; x += interval)
    vline(bmp, (int)x, 0, bmp->h, makecol(96, 96, 96));

  //Now do the vertical
  start = bmp->h/2 + (GRIDSIZE - modf(radarLoc.y/GRIDSIZE, &dummy) * GRIDSIZE) / ZOOMFACTOR;
  for (y = start; y > 0; y -= interval)
    hline(bmp, 0, (int)y, bmp->w, makecol(96, 96, 96));
  for (y = start; y < bmp->h; y += interval)
    hline(bmp, 0, (int)y, bmp->w, makecol(96, 96, 96));
}

void Radar::drawEntity(Entity* entity, BITMAP* bmp) {
  if (entity->isShip() && !((Ship*)entity)->isDead() && !((Ship*)entity)->isCloaked()) {
    const Point loc = entity->getLoc().getCenter();
    const IntPoint center((loc.x-radarLoc.x)/ZOOMFACTOR+bmp->w/2,
      (loc.y-radarLoc.y)/ZOOMFACTOR+bmp->h/2);
    triangle(bmp, center.x-2, center.y+2, center.x, center.y-2,
      center.x+2, center.y+2, makecol(192, 192, 192));

  } else if (entity->isRoid()) {
    const Point loc = entity->getLoc().getCenter();
    const IntPoint center((loc.x-radarLoc.x)/ZOOMFACTOR+bmp->w/2,
      (loc.y-radarLoc.y)/ZOOMFACTOR+bmp->h/2);
    //194,150,32 is just some brown color I approxed in PSP6
    hline(bmp, center.x-1, center.y, center.x+1, makecol(194, 150, 32));
    vline(bmp, center.x, center.y-1, center.y+1, makecol(194, 150, 32));

  } else if (entity->isBase()) {
    const Point loc = entity->getLoc().getCenter();
    const IntPoint center((loc.x-radarLoc.x)/ZOOMFACTOR+bmp->w/2,
      (loc.y-radarLoc.y)/ZOOMFACTOR+bmp->h/2);
    hline(bmp, center.x-1, center.y, center.x+1, makecol(192, 192, 192));
    vline(bmp, center.x, center.y-1, center.y+1, makecol(192, 192, 192));

  } else if (entity->isPlanet()) {
    const Point loc = entity->getLoc().getCenter();
    const IntPoint center((loc.x-radarLoc.x)/ZOOMFACTOR+bmp->w/2,
      (loc.y-radarLoc.y)/ZOOMFACTOR+bmp->h/2);
    //133,91,11 is just some dark brown color I approxed in PSP6
    circlefill(bmp, center.x, center.y, 5, makecol(133, 91, 11));
  }
}
