//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be appreciated.

#ifndef _PLAYER_H_
#define _PLAYER_H_

#include "Itana.h"

//class Prefs is an totally public class to help with organizing the
//controls, and preferences of the player.
class Prefs {
public:
  int c_left;       //turns ship left
  int c_right;      //turns ship right
  int c_slow;       //held to slow turn rate for precision
  int c_up;         //acceleration
  int c_down;       //"down" key
  int c_fast;       //afterburner
  int c_fire;       //normal fire
  int c_special;    //special ability/fire

  int c_fireleft;   //ornon fire left
  int c_fireright;  //ornon fire right
  int c_fireup;     //ornon fire up
  int c_firedown;   //ornon fire down

  int c_dock;       //dock/undock
  int c_bigradar;   //activate big radar

  int c_etos;       //energy transfer from main battery to shields
  int c_stoe;       //energy transfer from shields to main batter

  int c_scores;     //shows player scores
  int c_console;    //activate console
  int c_talk;       //talk to players
  int c_quit;       //quit game
  int c_shot;       //take screenshot

  int fastmouse;    //true if the mouse should be in fast mode

  int vsync;        //true if drawing should wait for sync
  int complexExp;   //true if complex explosions should be drawn

  int svol;         //sound volume level
  int mvol;         //music volume level

  Prefs() { defaultPrefs(); }

  void defaultPrefs();//sets player to default Prefs
  void loadPrefs();   //loads Prefs from config file
  void savePrefs();   //saves Prefs to config file
  void getControls(); //shows the control setting dialog
  static void getControl(int& control, const char* name);
    //to be used during frontend GUI to get controls, pass the control
    //you wish to change.
};

#endif