//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be appreciated.

#include "Itana.h"
#include "Prefs.h"

void Prefs::defaultPrefs() {
  //sets player to default Prefs
  c_left      = KEY_LEFT;
  c_right     = KEY_RIGHT;
  c_slow      = KEY_SPACE;
  c_up        = KEY_UP;
  c_down      = KEY_DOWN;
  c_fast      = KEY_LSHIFT;
  c_fire      = KEY_LCONTROL;
  c_special   = KEY_ALT;

  c_fireleft  = KEY_A;
  c_fireright = KEY_D;
  c_fireup    = KEY_W;
  c_firedown  = KEY_S;

  c_dock      = KEY_C;
  c_bigradar  = KEY_V;

  c_etos      = KEY_X;
  c_stoe      = KEY_Z;

  c_scores    = KEY_TAB;
  c_console   = KEY_TILDE;
  c_talk      = KEY_ENTER;
  c_quit      = KEY_ESC;
  c_shot      = KEY_F12;

  fastmouse   = 1;

  vsync       = 1;
}

void Prefs::loadPrefs() {   
  //loads Prefs from config file, error, use def
  c_left = get_config_int("controls", "left", KEY_LEFT);
  c_right = get_config_int("controls", "right", KEY_RIGHT);
  c_slow = get_config_int("controls", "turnrate", KEY_SPACE);
  c_up = get_config_int("controls", "up", KEY_UP);
  c_down = get_config_int("controls", "down", KEY_DOWN);
  c_fast = get_config_int("controls", "afterburn", KEY_LSHIFT);
  c_fire = get_config_int("controls", "fire", KEY_LCONTROL);
  c_special = get_config_int("controls", "special", KEY_ALT);

  c_fireleft = get_config_int("controls", "fireleft", KEY_A);
  c_fireright = get_config_int("controls", "fireright", KEY_D);
  c_fireup = get_config_int("controls", "fireup", KEY_W);
  c_firedown = get_config_int("controls", "firedown", KEY_S);

  c_dock = get_config_int("controls", "dock", KEY_C);
  c_bigradar = get_config_int("controls", "bigradar", KEY_V);

  c_etos = get_config_int("controls", "etos", KEY_X);
  c_stoe = get_config_int("controls", "stoe", KEY_Z);

  c_scores = get_config_int("controls", "scores", KEY_TAB);
  c_console = get_config_int("controls", "console", KEY_TILDE);
  c_talk = get_config_int("controls", "talk", KEY_ENTER);
  c_quit = get_config_int("controls", "quit", KEY_ESC);
  c_shot = get_config_int("controls", "screenshot", KEY_F12);

  fastmouse = get_config_int("controls", "fastmouse", 0);

  vsync = get_config_int("graphics", "vsync", 1);
  complexExp = get_config_int("graphics", "complexExplosions", 1);

  svol = get_config_int("sound", "soundVolume", 192);
  mvol = get_config_int("sound", "musicVolume", 192);
}

void Prefs::savePrefs() {   
  //saves Prefs to config file
  set_config_int("controls", "left", c_left);
  set_config_int("controls", "right", c_right);
  set_config_int("controls", "turnrate", c_slow);
  set_config_int("controls", "up", c_up);
  set_config_int("controls", "down", c_down);
  set_config_int("controls", "afterburn", c_fast);
  set_config_int("controls", "fire", c_fire);
  set_config_int("controls", "special", c_special);

  set_config_int("controls", "fireleft", c_fireleft);
  set_config_int("controls", "fireright", c_fireright);
  set_config_int("controls", "fireup", c_fireup);
  set_config_int("controls", "firedown", c_firedown);

  set_config_int("controls", "dock", c_dock);
  set_config_int("controls", "bigradar", c_bigradar);

  set_config_int("controls", "etos", c_etos);
  set_config_int("controls", "stoe", c_stoe);

  set_config_int("controls", "scores", c_scores);
  set_config_int("controls", "console", c_console);
  set_config_int("controls", "talk", c_talk);
  set_config_int("controls", "quit", c_quit);
  set_config_int("controls", "screenshot", c_shot);

  set_config_int("controls", "fastmouse", fastmouse);

  set_config_int("graphics", "vsync", vsync);
  set_config_int("graphics", "complexExplosions", complexExp);

  set_config_int("sound", "soundVolume", svol);
  set_config_int("sound", "musicVolume", mvol);
}
