//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be appreciated.

#include "Itana.h"
#include "Prefs.h"
#include "PrefMenus.h"
#include "keystrings.h"

void initializeControlsDialog(Prefs* prefs) {
  controlsDialog[20].dp = (void*)keyNames[prefs->c_fireup];
  controlsDialog[22].dp = (void*)keyNames[prefs->c_firedown];
  controlsDialog[24].dp = (void*)keyNames[prefs->c_fireright];
  controlsDialog[26].dp = (void*)keyNames[prefs->c_fireleft];
  controlsDialog[28].dp = (void*)keyNames[prefs->c_stoe];
  controlsDialog[30].dp = (void*)keyNames[prefs->c_etos];
  controlsDialog[32].dp = (void*)keyNames[prefs->c_dock];
  controlsDialog[34].dp = (void*)keyNames[prefs->c_bigradar];
  controlsDialog[36].dp = (void*)keyNames[prefs->c_up];
  controlsDialog[38].dp = (void*)keyNames[prefs->c_left];
  controlsDialog[40].dp = (void*)keyNames[prefs->c_right];
  controlsDialog[42].dp = (void*)keyNames[prefs->c_fast];
  controlsDialog[44].dp = (void*)keyNames[prefs->c_fire];
  controlsDialog[46].dp = (void*)keyNames[prefs->c_special];
  controlsDialog[48].dp = (void*)keyNames[prefs->c_scores];
  controlsDialog[50].dp = (void*)keyNames[prefs->c_console];
}

int* getControlByNumber(int num) {
  switch (num+1) { //num+1 because I'm lazy and using the above with S&R
  case 20: return &prefs->c_fireup;
  case 22: return &prefs->c_firedown;
  case 24: return &prefs->c_fireright;
  case 26: return &prefs->c_fireleft;
  case 28: return &prefs->c_stoe;
  case 30: return &prefs->c_etos;
  case 32: return &prefs->c_dock;
  case 34: return &prefs->c_bigradar;
  case 36: return &prefs->c_up;
  case 38: return &prefs->c_left;
  case 40: return &prefs->c_right;
  case 42: return &prefs->c_fast;
  case 44: return &prefs->c_fire;
  case 46: return &prefs->c_special;
  case 48: return &prefs->c_scores;
  case 50: return &prefs->c_console;
  default: return NULL;
  }
}

void Prefs::getControls() {
  ret = -1;
  while (ret == -1) {
    initializeControlsDialog(this);
    centre_dialog(controlsDialog);
    moveable_do_dialog(controlsDialog, 0);
    if (ret >= CONTROLS_START) {
      getControl(*getControlByNumber(ret), (const char*)controlsDialog[ret].dp);
      ret = -1;
    }
  }
}

void Prefs::getControl(int& control, const char* name) {
  //to be used during frontend GUI to get controls
  setControls[2].dp = (void*)strdup(name);
  setControls[3].dp = (void*)&control; //for d_getkey_proc

  centre_dialog(setControls);
  moveable_do_dialog(setControls, 0);

  delete[] (char*)setControls[2].dp;
  setControls[2].dp = NULL;
}

int d_getkey_proc(int msg, DIALOG *d, int c) {
  //For getting the keys the user wants to set his controls to.
  if (msg == MSG_IDLE) {
    int scancode = -1;
    for (int currcode = 1; currcode < KEY_MAX; currcode++) {
      if (key[currcode])
        scancode = currcode;
    }

    if (scancode != -1) {
      *((int*)d->dp) = scancode; //dp set before dialog starts
      return D_CLOSE;
    } else
      return D_O_K;
  } else
    return D_O_K;
}