//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#ifndef _POINT_H_
#define _POINT_H_

#include "Itana.h"

class Point {
public:
  double x;
  double y;

  Point() {}
  Point(double x2, double y2) : x(x2), y(y2) {}

  void init(double x2, double y2) {
    x = x2;
    y = y2;
  }

  double distFromOrigin() const {
    return fabs(sqrt(x*x+y*y));
  }

  double distTo(const Point& other) const {
    return fabs(sqrt(sq(other.x-x) + sq(other.y-y)));
  }

  double thetaTo(const Point& other) const {
    return atan2(other.y-y, other.x-x);
  }
protected:
private:
};

#endif