//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be appreciated.

#include "PlasmaBullet.h"
#include "Video.h"
#include "itanadat.h"
#include "EntityConsts.h"
#include "itanadat.h"

PlasmaBullet::PlasmaBullet(const Point& p, const Vector& rel, double theta)
: Bullet(p, rel, theta, ID_PLASMA) {
}

PlasmaBullet::PlasmaBullet() : Bullet( ID_PLASMA ) {
}

void PlasmaBullet::init(const Point& p, const Vector& rel, double theta) {
  Bullet::init(p, rel, theta, ID_PLASMA);
}

void PlasmaBullet::draw() {
  Video::drawSprite(GRFX_DAT_PLASBULL_BMP, loc, scrLoc, radToFix(getrndd(2*PI)));
}