//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#include "Itana.h"
#include "Network.h"
#include "NetworkDrivers.h"

Network::Network() {
  drivers = NULL;
  lastError = new char[128];
  sprintf(lastError, "No error");
  inRate = outRate = 1400;
  dataIn = dataOut = 0;
}

Network::~Network() {
  delete drivers;
  delete[] lastError;
}

bool Network::init() {
  //Returns true if network could not be initalized
  net_loadconfig(NULL);
  if (net_init())
    return true;
  else
    return false;
}

void Network::loadConfig() {
  //loads vars from config file if any
}

void Network::saveConfig() {
  //saves vars to config file if any
}

void Network::setRates(int inRate2, int outRate2) {
  inRate = inRate2;
  outRate = outRate2;
}

void Network::setDriver(int driver) {
  netDriver = driver;
}

NetworkDrivers* Network::getDrivers() {
  //gets all acceptable drivers
  if (drivers) {
    return drivers;
  } else {
    drivers = new NetworkDrivers();
    drivers->setList(net_drivers_all);
    drivers->detectDrivers();
    return drivers;
  }
}

bool Network::isConnected() {
  return true; //only Client can be disconnected
}
