//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#ifndef _MOVINGENTITY_H_
#define _MOVINGENTITY_H_

#include "Itana.h"
#include "Vector.h"
#include "Entity.h"
#include "OrbitingEntity.h"

class MovingEntity : public Entity {
public:
  MovingEntity() {}
  MovingEntity(const Rect& rect, const Vector& vect2)
    : Entity(rect), vect(vect2), theta(vect2.getTheta()) {}

  void init(const Rect& rect, const Vector& vect2) {
    vect = vect2; loc = rect; theta = vect2.getTheta();
  };

  const Vector& getVector() {return vect;}

  virtual void doCollision(Entity* other);

  virtual void input() = 0;
  virtual bool update();
  virtual void draw() = 0;

protected:
  Vector vect;
  double theta;   //angle of rotation
};

#endif