//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#include "Itana.h"
#include "MovingEntity.h"
#include "Video.h" //for MAP_SIZE constant
#include "Rect.h"

const double GRAV = 10000.0; //acceleration due to gravity at dist = 1

bool MovingEntity::update() {
  //calculate for gravity
  Point p = loc.getCenter();
  Vector gravVect;
  gravVect.initPolar(atan2(p.y, p.x)+PI, GRAV/sq(p.distFromOrigin()));
  vect.add(gravVect);

  vect.addTo(loc);
  if (loc.x < -MAP_SIZE) {
    loc.x = -MAP_SIZE;
    vect.clip(0.0);
  } else if (loc.x+loc.w >= MAP_SIZE) {
    loc.x = MAP_SIZE - loc.w;
    vect.clip(0.0);
  }
  if (loc.y < -MAP_SIZE) {
    loc.y = -MAP_SIZE;
    vect.clip(0.0);
  } else if (loc.y+loc.h >= MAP_SIZE) {
    loc.y = MAP_SIZE - loc.h;
    vect.clip(0.0);
  }
  return false;
}

void MovingEntity::doCollision(Entity* other) {
  if (other->getOwner() != this) {
    //radiate from the center of this Entity
    Point otherCenter = other->getLoc().getCenter();
    Point thisCenter = loc.getCenter();
    //subtract angles to find rotation
    vect.rotate(otherCenter.thetaTo(thisCenter) - vect.getTheta());
    vect.mult(0.4); //not perfectly elastic
    //back away from other object so we can't continue to "drill" into it
    vect.addTo(loc);
    while (isCollision(other))
      vect.addTo(loc);
  }
}