//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be appreciated.

#ifndef _MOVINGEFFECT_H_
#define _MOVINGEFFECT_H_

#include "Itana.h"
#include "Effect.h"
#include "Vector.h"

//This header is the only one of two with multiple classes (since these
//classes are very small)

class MovingEffect : public Effect {
public:
  MovingEffect(const Point& loc2, int life2, const Vector& vect2)
    : Effect(loc2, life2), vect(vect2) {}

  virtual bool update();
  virtual void draw() = 0;

protected:
  MovingEffect() {}
  Vector vect;//where it is moving
};

class FadeParticle : public MovingEffect {
public:
  FadeParticle(const Point& loc2, int life2, const Vector& vect2, int r2, int g2, int b2);

  bool update();
  void draw();
  
protected:
  int r, g, b;    //components of color
  int dr, dg, db; //subtracted every update to fade out
};

class Explosion : public MovingEffect {
public:
  Explosion(const Point& loc2, const Vector& vect2);
  static void initVideo(DATAFILE* root);

  void makeSound(); //uses the sound class to make a map sound based on its location

  bool update();
  void draw();

protected:
  int frame; //current image frame
  static DATAFILE* images;
};

#endif