//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#ifndef _MENUS_H_
#define _MENUS_H_

#include "Itana.h"
#include "MenuHelpers.h"

#ifdef ALLEGRO_WINDOWS
#define verno   ".7a Win"
#elif (defined ALLEGRO_DOS)
#define verno   ".7a DOS"
#elif (defined ALLEGRO_LINUX)
#define verno   ".7a Linux"
#endif

//define the portal from the loader in Itana.cpp to the frontend in Menus.cpp
bool mainMenu();

void doTitleScreen();
void doMainMenu();
 int doRaceSelection(); //Selects a race for single player
void instructions();
bool setupNetwork();
  //shows GUI dialog to setup networking.  False if all went well,
  //true on error or user canceled dialog
void doOptionsMenu();

bool  quit();
void  menu_pause();
char* driverListGetter(int index, int* list_size);
char* raceListGetter(int index, int* list_size);
char* connListGetter(int index, int* list_size);

/*
DIALOG blankDiag[] = {
  // (dialog proc)       (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)  (d1)  (d2)  (dp)
  {d_billwin_proc,        0,    0,  186,  101,     0,  0,    0,        0,    0,    0,  (void*)"Itana 1"verno},
  {d_ex_billbutton_proc,172,    4,   10,   10,     0,  0,    0,        0,    0,    0,  (void*)"x", setRet, NULL},
  {d_check_exit,          0,    0,    0,    0,     0,  0,    0,        0,    0,    0,  NULL},
  {d_yield_proc,          0,    0,    0,    0,     0,  0,    0,        0,    0,    0,  NULL},
  {NULL,                  0,    0,    0,    0,     0,  0,    0,        0,    0,    0,  NULL}
};
*/

DIALOG mainDialog[] = {
  /* (dialog proc)       (x)   (y)   (w)   (h)   (fg)  (bg)  (key) (flags)  (d1)  (d2)  (dp) */
  {d_billwin_proc,        0,    0,  224,  152,     0,  0,    0,        0,    0,    0,  (void*)"Itana 1 v"verno},
  {d_ex_billbutton_proc,210,    4,   10,   10,     0,  0,   27,        0,    0,    0,  (void*)"x", setRet, NULL},
  {d_ex_billbutton_proc, 32,   24,  160,   16,     0,  0,  's',        0,    0,    1,  (void*)"&Start Network Game", setRet, NULL},
  {d_ex_billbutton_proc, 32,   48,  160,   16,     0,  0,  'p',        0,    0,    4,  (void*)"Start Single &Player", setRet, NULL},
  {d_ex_billbutton_proc, 32,   72,  160,   16,     0,  0,  'i',        0,    0,    2,  (void*)"&Instructions", setRet, NULL},
  {d_ex_billbutton_proc, 32,   96,  160,   16,     0,  0,  'o',        0,    0,    3,  (void*)"&Options", setRet, NULL},
  {d_ex_billbutton_proc, 32,  120,  160,   16,     0,  0,  'q',        0,    0,    0,  (void*)"&Quit Game", setRet, NULL},
  {d_check_exit,          0,    0,    0,    0,     0,  0,    0,        0,    0,    0,  NULL},
  {d_yield_proc,          0,    0,    0,    0,     0,  0,    0,        0,    0,    0,  NULL},
  {NULL,                  0,    0,    0,    0,     0,  0,    0,        0,    0,    0,  NULL}
};

DIALOG raceDialog[] =
{
   /* (proc)               (x)  (y)  (w)  (h)  (fg) (bg) (key) (flags) (d1) (d2) (dp)                                        (dp2)   (dp3) */
   { d_billwin_proc,       0,   0,   296, 240, 0,   0,   0,    0,      0,   0,   (void*)"Ship Selection",                    NULL,   NULL },
   { d_billctext_proc,     144, 24,  8,   8,   0,   0,   0,    0,      0,   0,   (void*)"Please Select Your Race",           NULL,   NULL },
   { d_billctext_proc,     144, 40,  8,   8,   0,   0,   0,    0,      0,   0,   (void*)"Please note that single player is", NULL,   NULL },
   { d_billctext_proc,     144, 48,  8,   8,   0,   0,   0,    0,      0,   0,   (void*)"for exploration only.  The full",   NULL,   NULL },
   { d_billctext_proc,     144, 56,  8,   8,   0,   0,   0,    0,      0,   0,   (void*)"only available in multiplayer.",    NULL,   NULL },
   { d_billlist_proc,      8,   72,  280, 128, 0,   0,   0,    0,      0,   0,   raceListGetter,                             NULL,   NULL },
   { d_ex_billbutton_proc, 8,   208, 96,  24,  0,   0,   'o',  0,      0,   1,   (void*)"&OK",                               setRet, NULL },
   { d_ex_billbutton_proc, 192, 208, 96,  24,  0,   0,   27,   0,      0,   0,   (void*)"Cancel",                            setRet, NULL },
   { d_check_exit,         0,   0,   0,   0,   0,   0,   0,    0,      0,   0,   NULL,                                       0,      0    },
   { d_yield_proc,         0,   0,   0,   0,   0,   0,   0,    0,      0,   0,   NULL,                                       0,      0    },
   { NULL,                 0,   0,   0,   0,   0,   0,   0,    0,      0,   0,   NULL,                                       NULL,   NULL }
};

const int GUI_SINGLE_IDX = 5;

DIALOG instDialog[] =
{
   /* (proc)               (x)  (y) (w)  (h)  (fg) (bg) (key) (flags) (d1) (d2) (dp)                   (dp2)   (dp3) */
   { d_billwin_proc,       0,   0,  608, 408, 0,   0,   0,    0,      0,   0,   (void*)"Instructions", 0,      0    },
   { d_ex_billbutton_proc, 592, 0,  16,  18,  0,   0,   0,    0,      0,   0,   (void*)"X",            setRet, NULL },
   { d_billtextbox_proc,   8,   24, 592, 376, 0,   0,   0,    0,      0,   0,   (void*)"",             0,      0    },
   { d_check_exit,         0,   0,  0,   0,   0,   0,   0,    0,      0,   0,   NULL,                  0,      0    },
   { d_yield_proc,         0,   0,  0,   0,   0,   0,   0,    0,      0,   0,   NULL,                  0,      0    },
   { NULL,                 0,   0,  0,   0,   0,   0,   0,    0,      0,   0,   NULL,                  NULL,   NULL }
};

void** instText = &instDialog[2].dp;

DIALOG connectDialog[] = {
  /* (dialog proc)         (x)   (y)   (w)   (h)   (fg) (bg) (key) (flags) (d1)  (d2)  (dp)     (dp2)    (dp3) */
  {d_billwin_proc,          0,    0,  440,  376,    0,   0,  0,    0,        0,    0,    (void*)"Connecting to Server",    NULL,    NULL },
  {d_ex_billbutton_proc,  426,    4,   10,   10,    0,   0, 27,    0,        0,    0,    (void*)"x", setRet, NULL },
  {d_billctext_proc,      104,   32,  168,    8,    0,   0,  0,    0,        0,    0,    (void*)"Select Networking Method", NULL,    NULL },
  {d_billlist_proc,         8,   48,  200,  104,    0,   0,  0,    0,        0,    0,    driverListGetter,   NULL,    NULL },
  {d_billctext_proc,      104,  168,   88,    8,    0,   0,  0,    0,        0,    0,    (void*)"Select Race", NULL,    NULL },
  {d_billlist_proc,         8,  184,  200,   80,    0,   0,  0,    0,        0,    0,    raceListGetter,   NULL,    NULL },
  {d_billctext_proc,      328,   32,  200,    8,    0,   0,  0,    0,        0,    0,    (void*)"Enter Server's IP", NULL,    NULL },
  {d_billedit_proc,       224,   48,  208,   16,    0,   0,  0,    0,       16,    0,    editBufs[0],    NULL,    NULL },
  {d_billctext_proc,      328,   80,  152,    8,    0,   0,  0,    0,        0,    0,    (void*)"Enter Server's Port", NULL,    NULL },
  {d_billctext_proc,      328,   96,  144,    8,    0,   0,  0,    0,        0,    0,    (void*)"(default port is 58152)", NULL,    NULL },
  {d_billedit_proc,       224,  112,  208,   16,    0,   0,  0,    0,        6,    0,    editBufs[1],    NULL,    NULL },
  {d_billctext_proc,      328,  192,   90,    8,    0,   0,  0,    0,        0,    0,    (void*)"Select Connection Type", NULL,    NULL },
  {d_billlist_proc,       224,  208,  208,   80,    0,   0,  0,    D_DISABLED,        0,    0,    connListGetter,   NULL,    NULL },
  {d_billctext_proc,      328,  304,  176,    8,    0,   0,  0,    0,        0,    0,    (void*)"Custom Connection Type", NULL,    NULL },
  {d_billctext_proc,      328,  320,  176,    8,    0,   0,  0,    0,        0,    0,    (void*)"(bytes per sec max)", NULL,    NULL },
  {d_billctext_proc,      248,  336,   48,    8,    0,   0,  0,    0,        0,    0,    (void*)"Upload", NULL,    NULL },
  {d_billctext_proc,      392,  336,   64,    8,    0,   0,  0,    0,        0,    0,    (void*)"Download", NULL,    NULL },
  {d_billedit_proc,       224,  352,   72,   16,    0,   0,  0,    D_DISABLED,        6,   7,    editBufs[2],    NULL,    NULL },
  {d_billedit_proc,       360,  352,   72,   16,    0,   0,  0,    D_DISABLED,        6,    9,    editBufs[3],    NULL,    NULL },
  {d_ex_billbutton_proc,    8,  280,  200,   40,    0,   0,'c',    0,        0,    1,    (void*)"&Connect", setRet,    NULL },
  {d_ex_billbutton_proc,    8,  328,  200,   40,    0,   0,  0,    0,        0,    0,    (void*)"Cancel", setRet,    NULL },
  {d_billctext_proc,      328,  144,  112,    8,    0,   0,  0,    0,        0,    0,    (void*)"Enter Callsign", NULL,    NULL },
  {d_billedit_proc,       224,  160,  208,   16,    0,   0,  0,    4,       39,   10,    editBufs[4],    NULL,    NULL },
  {d_check_exit,            0,    0,    0,    0,    0,   0,  0,    0,        0,    0,    NULL},
  {d_yield_proc,            0,    0,    0,    0,    0,   0,  0,    0,        0,    0,    NULL},
  {NULL,                    0,    0,    0,    0,    0,   0,  0,    0,        0,    0,    NULL}
};

const int GUI_DRIVERLIST_IDX = 3;
const int GUI_RACELIST_IDX = 5;
const int GUI_CONNLIST_IDX = 12;

DIALOG optionsDialog[] =
{
   /* (proc)               (x)  (y)  (w)  (h)  (fg) (bg) (key) (flags) (d1) (d2) (dp)                   (dp2)   (dp3) */
   { d_billwin_proc,       0,   0,   424, 320, 0,   0,   0,    0,      0,   0,   (void*)"Options Menu",        NULL,   NULL },
   { d_ex_billbutton_proc, 409, 3,   13,  12,  0,   0,   27,   0,      0,   0,   (void*)"X",                   setRet, NULL },
   { d_billgroupbox_proc,  8,   24,  408, 112, 0,   0,   0,    0,      0,   0,   (void*)"Sound Options",       NULL,   NULL },
   { d_billslider_proc,    16,  56,  392, 24,  0,   0,   0,    0,      255, 192, NULL,                  NULL,   NULL },
   { d_billctext_proc,     208, 48,  8,   8,   0,   0,   0,    0,      0,   0,   (void*)"Sound Volume",        NULL,   NULL },
   { d_ex_billbutton_proc, 16,  288, 168, 24,  0,   0,   'o',  0,      0,   1,   (void*)"&OK / Apply Changes", setRet, NULL },
   { d_ex_billbutton_proc, 248, 288, 168, 24,  0,   0,   0,    0,      0,   0,   (void*)"Cancel",              setRet, NULL },
   { d_billgroupbox_proc,  8,   216, 408, 64,  0,   0,   0,    0,      0,   0,   (void*)"Controls",            NULL,   NULL },
   { d_billgroupbox_proc,  8,   144, 408, 64,  0,   0,   0,    0,      0,   0,   (void*)"Graphics Options",    NULL,   NULL },
   { d_billcheck_proc,     16,  232, 144, 16,  0,   0,   'm',  0,      1,   0,   (void*)"Fast GUI &Mouse",     NULL,   NULL },
   { d_ex_billbutton_proc, 280, 232, 128, 24,  0,   0,   's',  0,      0,   2,   (void*)"&Set Controls",       setRet, NULL },
   { d_billcheck_proc,     16,  160, 128, 16,  0,   0,   'v',  0,      1,   0,   (void*)"&Vsync on",           NULL,   NULL },
   { d_billcheck_proc,     245, 160, 168, 16,  0,   0,   'c',  0,      1,   0,   (void*)"&Complex Explosions", NULL,   NULL },
   { d_check_exit,         0,   0,   0,   0,   0,   0,   0,    0,      0,   0,   NULL,                  NULL,   NULL },
   { d_yield_proc,         0,   0,   0,   0,   0,   0,   0,    0,      0,   0,   NULL,                  NULL,   NULL },
   { NULL,                 0,   0,   0,   0,   0,   0,   0,    0,      0,   0,   NULL,                  NULL,   NULL }
};

int* OPT_SVOL    = &optionsDialog[3].d2;
int* OPT_MOUSE   = &optionsDialog[9].flags;
int* OPT_VSYNC   = &optionsDialog[11].flags;
int* OPT_COMPLEX = &optionsDialog[12].flags;

#endif
