//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#ifndef _ITANAPORT_H_
#define _ITANAPORT_H_

bool portInit();    //Inits porting functions, true if error

void yield();       //Ends this timeslice
void yield(int ms); //Ends this timeslice and returns ms ms later
void clearKeybuf(); //clears any waiting keys that getChar would read
char getChar(); //Non blocking.  Returns a char or 0 if nothing has been pressed

void initTimer(int ms); //Inits a timer to increment every ms milliseconds
int  getTimerCount();   //How many ticks
void decrementTimer();  //reduce by a tick
void startTimer();      //starts/resets timer, ticks set to 0, no need to ever stop

bool initProfile(const char* file);
                        //inits profiling capabilities returning true if cannot profile
                        //file is the file to output profiling info to
void startProfile();    //starts a profiling test
void stopProfile(const char* entry);
                        //stops a profiling test, prints <entry> : time to the file
void closeProfile();    //cleans up after initProfile

void portExit();//Exits porting functions

#endif