//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#ifdef WIN32

#include <Windows.h>
#include <conio.h>
#include <fstream>
#include "ItanaPort.h"

using namespace std;

bool portInit() {
  //Inits porting functions, true if error
  return false;
}

void yield() {
  //Ends this timeslice
  Sleep(0);
}

void yield(int ms) {
  Sleep(ms);
}

void clearKeybuf() {
  while (kbhit())
    int ch = getch();
}

char getChar() {
  //Non blocking.  Returns a char or 0 if nothing has been pressed
  if (kbhit())
    return (char)getch();
  else
    return 0;
}

static int ticks = 0;
static int tickLength = 0;
static DWORD lastTime = 0;

void initTimer(int ms) {
  //Inits a timer to increment every ms milliseconds
  tickLength = ms;
}

int getTimerCount() {
  //How many ticks
  DWORD newTime = GetTickCount();
  DWORD timeDiff = newTime - lastTime;
  ticks += (int)(timeDiff) / tickLength;
  lastTime = newTime - (timeDiff % tickLength);
  return ticks;
}

void decrementTimer() {
  //reduce by a tick
  ticks--;
}

void startTimer() {
  //starts/resets timer, ticks set to 0, no need to ever stop
  lastTime = GetTickCount();
  ticks = 0;
}

void portExit() {
  //Exits porting functions
}

static LARGE_INTEGER* rate;
static LARGE_INTEGER* start;
static ofstream* profile;

bool initProfile(const char* file) {
  rate = new LARGE_INTEGER;
  start = new LARGE_INTEGER;
  profile = new ofstream(file);
  if (QueryPerformanceFrequency(rate))
    return true;
  return false;
}

void startProfile() {
  QueryPerformanceCounter(start);
}

void stopProfile(const char* entry) {
  LARGE_INTEGER endTime;
  QueryPerformanceCounter(&endTime);
  ofstream& out = *profile;
  out << entry << ':'
      << double(endTime.QuadPart - start->QuadPart) / rate->QuadPart
      << " seconds." << endl;
}

void closeProfile() {
  profile->close();
  delete rate;
  delete start;
  delete profile;
}

#else

#include "ItanaPort.h"
#include <unistd.h>
#include <sys/time.h>

#ifdef ITANA_SERVER
//The client only needs the yield functions.
#include <ncurses.h>

bool portInit() {
  //Inits porting functions, true if error
	WINDOW* mainWin = initscr();
	cbreak();
	noecho();
	nodelay(mainWin, true);
  return false;
}

#endif // ITANA_SERVER
void yield() {
  //Ends this timeslice
  sleep(0);
}

void yield(int ms) {
  sleep(ms/1000);
}

#ifdef ITANA_SERVER
void clearKeybuf() {
  while (getch() != ERR) {}
}

char getChar() {
  //Non blocking.  Returns a char or 0 if nothing has been pressed
  int ret = getch();
  if (ret != ERR)
  	return (char)getch();
  else
    return 0;
}

#endif //ITANA_SERVER

static int ticks = 0;
static int tickLength = 0;
static long startSec = 0;
static int lastTime = 0;

int getms() {
  //Gets milliseconds from start of initTimer
  timeval tv;
  gettimeofday(&tv, NULL);
  int seconds = (int)(tv.tv_sec - startSec); //lower the number so we can compute a reasonable ms
  return ((seconds * 1000) + (tv.tv_usec / 1000));
}

void initTimer(int ms) {
  //Inits a timer to increment every ms milliseconds
  tickLength = ms;
  timeval tv;
  gettimeofday(&tv, NULL);
  startSec = tv.tv_sec;
}

int getTimerCount() {
  //How many ticks
  int newTime = getms();
  int timeDiff = newTime - lastTime;
  ticks += timeDiff / tickLength;
  lastTime = newTime - (timeDiff % tickLength);
  return ticks;
}

void decrementTimer() {
  //reduce by a tick
  ticks--;
}

void startTimer() {
  //starts/resets timer, ticks set to 0, no need to ever stop
  lastTime = getms();
  ticks = 0;
}

void portExit() {
#ifdef ITANA_SERVER
  //Exits porting functions
  endwin();
#endif
}

bool initProfile(const char* file) {
  return false;
}

void startProfile() {
}

void stopProfile(const char* entry) {
}

void closeProfile() {
}

#endif
