//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

//Global include for all Itana files

#ifndef _ITANA_H_
#define _ITANA_H_

//Include for precompiled headers
#ifdef _DEBUG
#define DEBUGMODE
#endif
#include "pch.h"

const double PI = 3.1415926535897932384626433832795;

//Math global inline functions
inline int    isq(int x) {
  return x*x;
}

inline double sq(double x) {
  return x*x;
}

inline double toRad(double theta) {
  return theta * PI / 180.0;
}

inline double toStd(double theta) {
  return theta * 180.0 / PI;
}

inline fixed radToFix(double theta) {
  return ftofix(theta * 128.0 / PI);
}

//Global variables
class Network;
extern Network* network;

class Console;
extern Console* console;

class Prefs;
extern Prefs* prefs;

#endif