//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#include "Itana.h"
#include "Network.h"
#include "Client.h"
#include "Video.h"
#include "Sound.h"
#include "Game.h"
#include "Prefs.h"
#include "Console.h"
#include "itanadat.h"
//define the portal from the loader in Itana.cpp to the frontend in Menus.cpp
bool mainMenu();

//Global variables
Network* network;
Console* console;
Prefs*   prefs;

static DATAFILE* root; //datafile
extern void** instText; //load instructions text here

void doError(char* msg);
int Loader();
int LoadData();

int main (int argc, char* argv[]) {
  switch (Loader()) {
    case 0:
      break;
    case 1:
      doError("  itana.dat NOT FOUND!\n");
      return 1;
    case 2:
      doError("  User Abort\n");
      return 2;
    case 3:
      doError("  Mouse error\n");
      return 3;
    case 4:
      doError("  Sound error\n");
      return 4;
    case 5:
      set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
#ifdef ALLEGRO_DOS
      allegro_message( "Itana needs a VESA compatable video card capable of hicolor in 800x600!\nError: %s\nGeneral Suggestions -- get VESA drivers from your video card manufacturer or\ndownload scitech display doctor\nFor help contact gillius@webzone.net or see http://www.rit.edu/~jpw9607/\n", allegro_error);
#elif (defined ALLEGRO_WINDOWS)
      allegro_message( "Itana needs a compatable video card capable of hicolor in 800x600!\nError: %s\nGeneral Suggestions -- Update your video card drivers to latest version and get\nthe latest DirectX.\nFor help contact gillius@webzone.net or see http://www.rit.edu/~jpw9607/\n", allegro_error);
#endif
      return 5;
    case 6:
      doError("Network did not properly initalize");
      return 6;
    default:
      doError("  Unknown error\n");
      return 255;
  }

  //pass control to frontend, game
  if (mainMenu())
      doError("  Unknown error\n");

  prefs->savePrefs();
  unload_datafile(root);

  delete network;
  Video::destruct();
  delete console;
  Game::destruct();
  delete prefs;
  allegro_exit();
  return 0;
}
END_OF_MAIN()

void doError(char* msg) {
  set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
  allegro_message(msg);
}

int Loader() {
  if (allegro_init())
    return -1;
  randomize();    //Initalize jrnd.h

  network = new Client();
  Video::construct();
  console = new Console();
  Game::construct();
  prefs = new Prefs();

  set_config_file("itana.cfg");
  set_uformat(U_ASCII); //Just to be safe since I don't use any of the
                        // unicode routines
  set_window_title("Itana 1");

  if (Video::setVideoMode())
    return 5;

  if (LoadData())
    return 1;
  Video::init(root);
  Game::init();

  install_timer();
  install_keyboard();
  install_mouse();
  
  if (install_sound(DIGI_AUTODETECT, MIDI_NONE, NULL)) {
    return 4;
  }
  Sound::init(root);

  if (network->init())
    return 6;

  return 0;
}

int LoadData() {
  set_color_conversion(COLORCONV_TOTAL | COLORCONV_DITHER);
  prefs->loadPrefs();

  if (!(root = load_datafile("itana.dat")))
    return 1; //error
  else {
    //Load instructions into menu dialog
    *instText = root[INSTRUCTIONS].dat;
    return 0;
  }
}