//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be appreciated.

#ifndef _INTPOINT_H_
#define _INTPOINT_H_

#include "Itana.h"
#include "Point.h"

class IntPoint {
public:
  int x;
  int y;

  IntPoint() {}
  IntPoint(int x2, int y2) : x(x2), y(y2) {}
  IntPoint(Point point) : x((int)point.x), y((int)point.y) {}

  void init(int x2, int y2) {
    x = x2;
    y = y2;
  }

  double distTo(const IntPoint& other) const {
    return fabs(sqrt(isq(other.x-x) + isq(other.y-y)));
  }
protected:
private:
};

#endif