//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#include "Itana.h"
#include "itanadat.h"
#include "HumanShip.h"
#include "Video.h"
#include "ShipStats.h"
#include "Vector.h"
#include "HumanBullet.h"
#include "Game.h"
#include "Sound.h"
#include "MovingEffect.h"
#include "Console.h"
#include "PacketConsts.h"

const double BLASTER_RECOIL = 0.4;

HumanShip::HumanShip() {
  type = HUMAN_STATS;
  id = ID_HUMAN_SHIP;
}

void HumanShip::init(const Rect& rect, const Vector& vect) {
  Ship::init(rect, vect);
}

void HumanShip::input() {
  Ship::input();
}

bool HumanShip::update() {
  return Ship::update();
}

void HumanShip::draw() {
  if (!dead) {
    if (actions & CLOAKED) {
      if (control == CTRL_LOCAL || (actions & FIREUP)) 
      //Draw a transparent sprite if we are ourselves, or if the enemy is firing
      Video::drawTransSprite(GRFX_DAT_HUMSHIP_BMP, loc, scrLoc, radToFix(theta));
      //else we do not draw a ship
    } else
      Video::drawSprite(GRFX_DAT_HUMSHIP_BMP, loc, scrLoc, radToFix(theta));
    Ship::draw();
  }
}

void HumanShip::fire(int dir) {
  //Human ships fire a blaster.  Direction does not matter.
  if (energy >= STATS[type].fireuse) {
    if (normalReload == 0) {
      Sound::playMapSound(SFX_DAT_GUN_WAV, loc.getCenter());
      Ship::fire(new HumanBullet(loc.getCenter(), vect, theta), theta + PI, BLASTER_RECOIL);
      energy -= STATS[type].fireuse;
      normalReload = STATS[type].firedelay;
    }
    actions |= FIREUP;
  }
}

void HumanShip::special() {
  if (energy >= STATS[type].specialuse) {
    actions |= CLOAKED;
    energy -= STATS[type].specialuse;
  }
}

void HumanShip::throwEngineParticle(const Vector& partVect) {
  if ((Game::getFrame() % 2) == 0) {
    Vector temp(-15, getrnd(15)-7);

    temp.rotate(theta);
    double midx = loc.x + loc.w/2;
    double midy = loc.y + loc.h/2;
    FadeParticle* newParticle = new FadeParticle(Point(midx + temp.getMagx(), midy + temp.getMagy()),
                                                 200, partVect, 255, 255, 255);
    Game::moveEffect(newParticle);
  }
}