//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#ifndef _ENTITY_H_
#define _ENTITY_H_

#include "Itana.h"
#include "Rect.h"
#include "IntRect.h"
#include "EntityConsts.h"
#include "Packet.h"

//Entity is the class that pretty much everything revolves around.  Anything
//in the game that "exists" is an Entity.  All Entities collide with all other
//entities, and an object must be an Entity to interact with its environment.
//Most things are Entities, but things like purely cosmetic effects are not
//Entities (see class Effect).

class Entity {
public:
  Entity();
    //default constructor does not properly initalize class
  Entity(const Rect& loc2);

  void init(const Rect& loc2);
  void setOwner(Entity* own);

  int getId() {return id;}
  Entity* getOwner() {return owner;}

  bool isShip();
  bool isBase();
  bool isRoid();
  bool isPlanet();
  bool isBullet();
    //these id functions are guaranteed to also imply that this Entity is
    //a member of the relevant class, and is castable.

  Rect getLoc() {return loc;} //this will be used mainly to center view

  virtual void doCollision(Entity* other) = 0;
    //allows objects to collide with another Entity, perhaps interacting

  bool isCollision(const Entity* other) {
    return loc.isCollision(other->loc);
  }

  //Networking functions
  virtual Packet* makePacket(); //Makes a NEW packet of an approprate type
  virtual void    usePacket(Packet* packet);
    //if the packet is of the right type, update this object, else do nothing

  virtual void input() = 0; //Gets input from an input source
  virtual bool update() = 0;//calculates game logic (true if dies)
  virtual void draw() = 0;  //tells Video to draw

protected:
  Entity* owner;//Who owns this entity?  owner == this if the object is "independant"
  void initScrLoc(); //inits scrLoc
  Rect loc;
  IntRect scrLoc;//since rotating sprites take up more than their orig
               //width and heigth, this resembles offsets from loc's
               //x,y and new width and height for use in Video
  int id;
};

#endif