//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#include "Itana.h"
#include "Entity.h"

Entity::Entity() {
  owner = this;
}

Entity::Entity(const Rect& loc2) : loc(loc2) {
  initScrLoc();
}

void Entity::init(const Rect& loc2) {
  loc = loc2;
  initScrLoc();
}

void Entity::setOwner(Entity* own) {
  owner = own;
}

bool Entity::isShip() {
  return ((id >= MIN_ID_SHIP) && (id <= MAX_ID_SHIP));
}

bool Entity::isBase() {
  return ((id >= MIN_ID_BASE) && (id <= MAX_ID_BASE));
}

bool Entity::isRoid() {
  return (id == ID_ROID);
}

bool Entity::isPlanet() {
  return (id == ID_PLANET);
}

bool Entity::isBullet() {
  return ((id >= MIN_ID_BULLET) && (id <= MAX_ID_BULLET));
}

Packet* Entity::makePacket() {
  //Makes a packet of an approprate type
  return new Packet(); //there's nothing to describe (default behavior)
}

void Entity::usePacket(Packet* packet) {
  //do nothing since nothing can be changed here (default behavior)
}

void Entity::initScrLoc() {
  //we now need to create the video rect, which will be a square
  //The +2 creates a 1 pixel border.  Sometimes this formula leaves
  //some stray pixels even.
  scrLoc.w = scrLoc.h = (int)(sqrt(sq(loc.w)+sq(loc.h))) + 2;
  //now create offsets
  scrLoc.x = -(scrLoc.w - (int)loc.w) / 2;
  scrLoc.y = -(scrLoc.h - (int)loc.h) / 2;
}