//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be appreciated.

#ifndef _EFFECT_H_
#define _EFFECT_H_

#include "Itana.h"
#include "Point.h"

//The effect class manages "eye-candy" things that have no other interaction
//with the environment besides purely visual, like particles and explosions.
class Effect {
public:
  Effect(const Point& loc2, int life2) : loc(loc2), life(life2) {}

  virtual bool update();
  virtual void draw() = 0;

protected:
  Effect() {}
  Point loc;
  int life;  //number of frames this effect lasts
};

#endif
