//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#ifndef _CONSOLE_H_
#define _CONSOLE_H_

class ConsoleLine;

class Console {
public:
  Console();
  ~Console();

  void addLine(char* format, ...); //Adds a line of text

  bool isOpen() const;//Returns true if Console is open for input

  void input(); //Handles input from user
  void draw() const;  //Draws lines of text to screen
  void update();//Updates the lines
private:
  void interpretInput();//Interprets a just-entered inputStr

  ConsoleLine* lines;
  int nextLine;

  bool scoreDisplay;//Are we displaying scores?

  //Variables for console input
  bool consoleOpen; //Are we receiving input?
  int currPos;      //current cursor position
  char* inputStr;   //The actual data
};

#endif