//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#include "Itana.h"
#include "Console.h"
#include "ConsoleLine.h"
#include "Video.h"
#include "IntRect.h"
#include "Prefs.h"
#include "Packet.h"
#include "Network.h"
#include "NetPeer.h"
#include "itanadat.h"
#include "Sound.h"

#ifdef ITANA_SERVER
#include "ItanaPort.h"
#endif

const char BACKSPACE = 8;
const char ENTER     = 13;
const int INPUT_SIZE = 70;
const char* PROMPT   = "> ";
const int PROMPT_SIZE = 2;

const int NUM_LINES = 10;
const int TIME_TO_LIVE = 800; //in frames

const IntRect START(16, 96, 0, 0); //First console line
const IntRect INPUT(16, scry - 36, 0, 0); //Console input area

Console::Console() : lines( new ConsoleLine[NUM_LINES] ), nextLine( 0 ), 
                     scoreDisplay(false), consoleOpen( false ), currPos( 0 ),
                     inputStr( new char[INPUT_SIZE] ) {
}

Console::~Console() {
  delete[] lines;
  delete[] inputStr;
}

void Console::addLine(char* format, ...) {
  //Adds a line of text
  //create the string
  char buf[512];
  va_list ap;
  va_start(ap, format);
  vsprintf(buf, format, ap);
  va_end(ap);

  lines[nextLine].reInit(buf, TIME_TO_LIVE);
  
  //Increment nextLine
  nextLine++;
  if ( nextLine >= NUM_LINES )
    nextLine = 0;
}

bool Console::isOpen() const {
  //Returns true if Console is open for input
  return consoleOpen;
}

void Console::input() {
  //Handles input from user
  if (key[prefs->c_scores])
    scoreDisplay = true;
  else
    scoreDisplay = false;
  if (!consoleOpen) {
    if (key[prefs->c_console]) {
      consoleOpen = true;
      strcpy(inputStr, PROMPT);
      currPos = PROMPT_SIZE;
      //clear out the key buffer
#ifdef ITANA_SERVER
      clearKeybuf();
#else
      clear_keybuf();
#endif

    }
  } else {
    //Get the next character in the input if exists
    if (keypressed()) {
#ifdef ITANA_SERVER
      char next = getChar();
#else
      char next = readkey() & 0xff;
#endif
      if ( next == ENTER ) { //end input
        interpretInput();
        consoleOpen = false;
      } else if ( next == BACKSPACE ) { //go back
        currPos--;
        if (currPos < PROMPT_SIZE)
          currPos = PROMPT_SIZE;
      } else {
        inputStr[currPos] = next;
        currPos++;
        if (currPos > INPUT_SIZE - 1)
          currPos = INPUT_SIZE - 1;
      }
      inputStr[currPos] = '\0';
    }
  }
}

void Console::draw() const {
  //Draws lines of text to screen
  IntRect currLoc(START);
  for (int iter=0; iter < NUM_LINES; iter++) {
    if (lines[iter].isActive()) {
      Video::drawText(currLoc, makecol(192,192,192), lines[iter].getLine());
    }
    currLoc.y += text_height(font);
  }
  if (consoleOpen)
    Video::drawText(INPUT, makecol(255, 255, 255), inputStr);
  if (scoreDisplay) {
    IntRect scoreLoc(16, START.y + (NUM_LINES+3) * text_height(font), 0, 0);
    Video::drawText(scoreLoc, makecol(192,192,192), "Net Stats:");
    scoreLoc.y += text_height(font);
    Video::drawText(scoreLoc, makecol(192,192,192), "dataOut: %i  dataIn: %i", network->dataOut, network->dataIn);
    scoreLoc.y += text_height(font);
    Video::drawText(scoreLoc, makecol(192,192,192), "name(ID)  kills/deaths/latency");
    scoreLoc.y += text_height(font);

    const NetPeer** peers = network->getPeers();
    int c = 0;
    const NetPeer* currPeer = peers[c];
    while (currPeer != NULL) {
      Video::drawText(scoreLoc, makecol(192,192,192), "%s(%i) %i %i %ims",
        currPeer->data.getName(), currPeer->data.playerId,
        currPeer->data.kills, currPeer->data.deaths, currPeer->latency);
      scoreLoc.y += text_height(font);
      currPeer = peers[++c];
    }
    delete[] peers;
  }
}

void Console::update() {
  //Updates the lines
  for (int iter=0; iter < NUM_LINES; iter++)
    lines[iter].update();
}

void Console::interpretInput() {
  const char* realStr = &inputStr[PROMPT_SIZE]; //Skip the prompt
  if (strlen(realStr) > 0 && realStr[0] == '/') {
    //process this as a command
  } else {
    //This is a chat message -- we realize this won't work in single player
    //but it won't hurt either unless the player types so many messages that
    //we run out of memory.
    PlayerMessagePacket* chat = new PlayerMessagePacket();
    chat->setMessage(realStr);
    network->sendPacket(chat, true);
    addLine("%s: %s", network->getOurName(), realStr);
    Sound::playSound(SFX_DAT_INMSG_WAV);
  }
}