//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be appreciated.

#ifndef _Client_h_
#define _Client_h_

#include "Itana.h"
#include "Network.h"
#include "PacketConsts.h"
class Packet;
class DynamicEntityPacket;
class ShipPacket;
class PlayerPacket;
class PlayerPartPacket;
class OrbitingEntityPacket;
class DeathPacket;
class NetPeer;

class Client : public Network {
public:
  Client();
  ~Client();

  PlayerId whoIsThis(void* other);
    //Trys to find what player id this object is bound to
  const char* getName(PlayerId id);
    //Returns the player name associated with this PlayerId
  const char* getOurName() const;
    //Returns our name, or "Player" if not connected
  const NetPeer** getPeers();
    //For Console -- returns an NEWLY ALLOCATED array of NetPeer*
    //pointing to objects to display which won't be deleted.
    //The last pointer is NULL to signify the end of the array.

  void sendPacket(Packet* packet, bool reliable);
    //Sends a packet to the server.
    //Client handles memory allocation of packet, and will delete it.

  bool connect(char* target, const char* name, int shipType);
    //true if error in connecting to server
  void disconnect();
    //disconnect (part) from the game server
  bool isConnected();
    //Are we connected to the network (always true for server)

  bool update();
    //returns true only on an unrecoverable error which would require
    //termination of the network connection

private:
  void clientInit();
  NetPeer* findPlayer(PlayerId id);
  void deletePlayer(NetPeer* peer);
  void doBindings(NetPeer* peer);

  //Packet Handlers
  void handlePacket(Packet* next);
  void handleDynamicEntityPacket(DynamicEntityPacket* packet);
  void handleShipPacket(ShipPacket* packet);
  void handlePlayerPacket(PlayerPacket* packet);
  void handlePlayerPartPacket(PlayerPartPacket* packet);
  void handleOrbitingEntityPacket(OrbitingEntityPacket* packet);
  void handleDeathPacket(DeathPacket* packet);

  bool connected;         //Have we finished connecting?
  LinkList<NetPeer> peers;//everyone's data (not ours!)
  NetPeer* us;            //our data

  int getNextPacket(char* buf, int bufSize);
  //Gets next packet, if there was one.  Netbuf needs to be large enough to hold a
  //UDP packet sized data (600+).  Returns -1 on error, or the number of bytes
  //received (note if there is no pending data, getNextPacket returns 0).
  int sendTCPPacket();
  //Sends as many pending TCP game packets as possible in a single network packet.
  //Returns bytes of data sent.
  int sendUDPPacket();
  //Sends as many pending UDP game packets as possible in a single network packet.

  char* tempBuf; //for RDM sending usage to hold a pending packet when buffer overflows
  int tempBufLen;//length of temporary RDM packet

  NET_CONN*    serverTCP;     //TCP connection to server
  LinkQueue<Packet> TCPqueue; //queue of reliable packets to send
  NET_CHANNEL* serverUDP;     //UDP connection to server
  LinkQueue<Packet> UDPqueue; //queue of unreliable packets to send
};

#endif /* #ifndef _Client_h_ */
