//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be appreciated.

#include "BlasterBullet.h"
#include "Video.h"
#include "itanadat.h"
#include "EntityConsts.h"

BlasterBullet::BlasterBullet(const Point& p, const Vector& rel, double theta)
: Bullet(p, rel, theta, ID_BLASTER) {
}

BlasterBullet::BlasterBullet() : Bullet( ID_BLASTER ) {
}

void BlasterBullet::init(const Point& p, const Vector& rel, double theta) {
  Bullet::init(p, rel, theta, ID_BLASTER);
}

void BlasterBullet::draw() {
  Video::drawSprite(GRFX_DAT_BLASTBULL_BMP, loc, scrLoc, radToFix(theta));
}
