//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#ifndef _BASE_H_
#define _BASE_H_

class Ship;
#include "OrbitingEntity.h"

class Base : public OrbitingEntity {
public:
  Base(double dist2, double theta2, int type2);

  void init(double dist2, double theta2, int type2);
  void bindShip(Ship* ship) { myShip = ship; }
  void dock() { docked = true; }
  void undock() { docked = false; }

  //Networking functions
  virtual Packet* makePacket(); //Makes a NEW packet of an approprate type
  virtual void    usePacket(Packet* packet);
  void    makeObsolete() {obsolete = true;} //player leaves
    //if the packet is of the right type, update this object, else do nothing

  bool update();
  void draw();

protected:
  Base() {}

  int armor;   //life of base
  int type;    //for usage in stats
  double rot;  //angle of rotation
  bool docked; //true if we are docked to myShip
  bool obsolete;//true if the player attached to this base has parted
  Ship* myShip;//NULL if not docked, else pointer to a ship

  void repair();//repairs the docked ship
  void throwRepairParticle();
};

#endif