//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#include "Itana.h"
#include "Base.h"
#include "BaseStats.h"
#include "Video.h"
#include "Ship.h"
#include "Game.h"
#include "MovingEffect.h"
#include "Network.h"

const double BASE_ROTATION_SPEED = 0.05;

Base::Base(double dist2, double theta2, int type2) {
  init (dist2, theta2, type2);
}

void Base::init(double dist2, double theta2, int type2) {
  type = type2 - MIN_ID_BASE;
  id = type2;
  armor = BASESTATS[type].armor;
  rot = getrndd(2*PI);
  docked = obsolete = false;
  Rect rect;
  rect.w = BASESTATS[type].width;
  rect.h = BASESTATS[type].height;
  OrbitingEntity::init(rect, dist2, theta2);
}


Packet* Base::makePacket() {
  //Makes a NEW packet of an approprate type
  OrbitingEntityPacket* ret = new OrbitingEntityPacket();
  ret->dist = dist;
  ret->frame = Game::getFrame();
  ret->life = armor;
  ret->objectId = id;
  ret->playerId = network->whoIsThis(this);
  ret->theta = theta;
  return ret;
}

void Base::usePacket(Packet* packet) {
  if (packet->getType() == ORBITINGENTITY) {
    OrbitingEntityPacket* data = (OrbitingEntityPacket*)packet;
    init(data->dist, data->theta, data->objectId);
    armor = data->life;
    int currFrame = Game::getFrame();
    for(int c=data->frame; c<currFrame; c++)
      update();
  }
}

bool Base::update() {
  if (docked)
    repair();
  rot += BASE_ROTATION_SPEED;
  OrbitingEntity::update();
  return (obsolete);
}

void Base::draw() {
  //rot is a double in the 256 degree system
  Video::drawSprite(BASESTATS[type].idx, loc, scrLoc, ftofix(rot));
}

void Base::repair() {
  //Repairs the docked ship
  myShip->getRepaired(BASESTATS[type].regenrate, BASESTATS[type].regenrate, BASESTATS[type].regenrate);
  //Throw particles at this ship
  throwRepairParticle();
  throwRepairParticle();
  throwRepairParticle();
}

void Base::throwRepairParticle() {
  Point ship = myShip->getLoc().getCenter();
  Point base = loc.getCenter();
  double theta = atan2(ship.y-base.y, ship.x-base.x);
  Vector partVect;
  partVect.initPolar(theta + getrndd(PI/16) - PI/64, 8.0);
  Game::moveEffect(new FadeParticle(base, 40, partVect, 255, 255, 0));
}