//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#include "Itana.h"
#include "Asteroid.h"
#include "Video.h"
#include "itanadat.h"
#include "Packet.h"
#include "Game.h"

const Rect ROIDRECT(0.0, 0.0, 64.0, 64.0);
const double ROID_ROTATION_SPEED = 0.1;
const int NUM_ROIDS = 3;

void Asteroid::init(double dist, double theta) {
  OrbitingEntity::init(ROIDRECT, dist, theta);
  //NASTY HACK!!! Yes I know and the datafile roids must be contiguous elements...
  img = GRFX_DAT_ROID0_BMP + getrnd(NUM_ROIDS);
  rot = getrndd(256.0);
}

Packet* Asteroid::makePacket() {
  //Makes a NEW packet of an approprate type
  OrbitingEntityPacket* ret = new OrbitingEntityPacket();
  ret->dist = dist;
  ret->frame = Game::getFrame();
  ret->life = 0;
  ret->objectId = id;
  ret->playerId = 0;
  ret->theta = theta;
  return ret;
}

void Asteroid::usePacket(Packet* packet) {
  if (packet->getType() == ORBITINGENTITY) {
    OrbitingEntityPacket* data = (OrbitingEntityPacket*)packet;
    init(data->dist, data->theta);
    int currFrame = Game::getFrame();
    for(int c=data->frame; c<currFrame; c++)
      update();
  }
}

bool Asteroid::update() {
  rot += ROID_ROTATION_SPEED;
  OrbitingEntity::update();
  return false; //never dies
}

void Asteroid::draw() {
  //rot is a double in the 256 degree system
  Video::drawSprite(img, loc, scrLoc, ftofix(rot));
}