//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#include "Itana.h"
#include "Video.h"
#include "Prefs.h"
#include "Sound.h"
#include "Game.h"
#include "Network.h"
#include "NetworkDrivers.h"
#include "ItanaPort.h"
#include "ItanaServer.h"
#include "Server.h"
#include "Console.h"

#ifdef ALLEGRO_WINDOWS
#define verno   ".001a Win Server"
#elif (defined ALLEGRO_DOS)
#define verno   ".001a DOS Server"
#elif (defined ALLEGRO_LINUX)
#define verno   ".001a Linux Server"
#endif

//Global variables
Network* network;
Console* console;
Prefs*   prefs;

int main(int argc, char* argv[]) {
  cout << verno << endl;
  portInit();
  randomize();

  network = new Server();
  Video::construct();
  console = new Console();
  Game::construct();
  prefs = new Prefs();

  if (network->init()) {
    allegro_message("Network intialization error");
    return 1;
  }

  NetworkDrivers* drivers = network->getDrivers();
  cout << "Detected " << drivers->getLength() << " drivers:" << endl;
  for (int c=0; c<drivers->getLength(); c++) {
    cout << "  " << c << " - " << drivers->getName(c) << endl;
  }

  int resp = -1;
  cout << endl << "Please select a driver: ";
  cin >> resp;
  while ((resp < 0) || (resp >= drivers->getLength())) {
    cout << "Error in choice please pick a valid driver: ";
    cin >> resp;
  }
  network->setDriver(drivers->getId(resp));

  cout << "Please note: ports under 1024 are HIGHLY unsuggested as these are reserved" << endl;
  cout << "  ports which common internet application use." << endl;
  cout << "  Ports range 1-65535 (0 is not allowed)" << endl;
  cout << "Please select a listen port (default: " << DEFAULT_PORT << "): ";
  cin >> resp;
  while ((resp < 1) || (resp > 65535)) {
    cout << "Ports range from 1 to 65535, please select one in this range: ";
    cin >> resp;
  }

  //launch the server
  if (((Server*)network)->doServer(resp))
    cout << "Error: " << network->getLastError() << endl;

  delete network;
  Video::destruct();
  delete console;
  Game::destruct();
  delete prefs;

  net_shutdown();
  portExit();
  return 0;
} END_OF_MAIN()
