//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be appreciated.

#include "Itana.h"
#include "Server.h"
#include "ItanaServer.h"
#include "Ship.h"
#include "BlasterBullet.h"
#include "PlasmaBullet.h"
#include "HumanBullet.h"
#include "ZylexBullet.h"
#include "OrnonBullet.h"
#include "ParaBullet.h"
#include "Game.h"
#include "Base.h"
#include "ServerPrivate.h"

bool Server::handlePacket(Packet* next, NetPlayer* peer) {
  //Handle loss/late, dropout
  if (peer->lastTime < next->frame)
    peer->lastTime = next->frame;
  
  //handle actual packet data
  switch(next->getType()) {
  case SHIP:
    handleShipPacket((ShipPacket*)next, peer);
    break;
  case DYNAMICENTITY:
    handleDynamicEntityPacket((DynamicEntityPacket*)next, peer);
    break;
  case PLAYER:
    cout << "Illegal packet received -- PlayerPacket." << endl;
    break;
  case PLAYERPART:
    handlePlayerPartPacket((PlayerPartPacket*)next, peer);
    return true; //this will delete the player
  case PLAYERMESSAGE:
    cout << peer->data.getName() << ": " << ((PlayerMessagePacket*)next)->getMessage() << endl;
    addToAllTCP(*next, peer, players);
    break;
  case ORBITINGENTITY:
    cout << "Illegal packet received -- OrbitingEntityPacket." << endl;
    break;
  case FRAME:
    cout << "Illegal packet received -- FramePacket." << endl;
    break;
  case DAMAGE:
    cout << "Illegal packet received -- DamagePacket." << endl;
    break;
  case DEATH:
    handleDeathPacket((DeathPacket*)next, peer);
    break;
  case RESPAWN:
    peer->ship->usePacket(next);
    addToAllTCP(*next, peer, players);
    addToAllTCP(*next, peer, connecting);
    break;
  case PING:
    {
      peer->latency = (Game::getFrame() - next->frame) * 10 / 2; //pingtime /2
      StatsPacket* stats = peer->getStats();
      addToAllUDP(*stats, NULL, players);
      delete stats;
    }
    break;
  default:
    cout << "Unknown packet received." << endl;
  }
  return false;
}

void Server::handleShipPacket(ShipPacket* packet, NetPlayer* peer) {
  if (peer->lastPosUpdate < packet->frame) {
    peer->ship->usePacket(packet);
    peer->lastPosUpdate = packet->frame;
    addToAllUDP(*packet, peer, players);
  }
}

void Server::handleDynamicEntityPacket(DynamicEntityPacket* packet, NetPlayer* peer) {
  //Check for late position packet
  peer->ship->usePacket(packet);
  peer->lastPosUpdate = packet->frame;
  
  Bullet* bull = NULL;
  switch (packet->objectId) {
  case ID_BLASTER:
    bull = new BlasterBullet();
    break;
  case ID_HUMANBULLET:
    bull = new HumanBullet();
    break;
  case ID_ORNONBULLET:
    bull = new OrnonBullet();
    break;
  case ID_ZYLEXBULLET:
    bull = new ZylexBullet();
    break;
  case ID_PARA:
    bull = new ParaBullet();
    addToAllTCP(*packet, peer, players);
    break;
  case ID_PLASMA:
    bull = new PlasmaBullet();
    addToAllTCP(*packet, peer, players);
    break;
  }
  if (bull) {
    bull->usePacket(packet);
    bull->setOwner(peer->ship);
    Game::moveEntity(bull);
  } else
    cout << "Illegal DynamicEntityPacket from " << peer->data.getName() << '.' << endl;
}

void Server::handlePlayerPartPacket(PlayerPartPacket* packet, NetPlayer* peer) {
  peer->ship->makeObsolete();
  peer->base->makeObsolete();
  addToAllTCP(*packet, peer, players);
  addToAllTCP(*packet, peer, connecting);
}

void Server::handleDeathPacket(DeathPacket* packet, NetPlayer* peer) {
  peer->data.deaths++;
  switch( packet->type ) {
  case PLANETDEATH:
    cout << peer->data.getName() << " couldn't manage to avoid an entire planet." << endl;
    break;
  case BANGEDDEATH:
    cout << peer->data.getName() << " got banged up." << endl;
    break;
  case SHOTDEATH:
    {
      NetPlayer* other = findPlayer(packet->other);
      other->data.kills++;
      cout << peer->data.getName() << " was blown to bits by "
        << other->data.getName() << '.' << endl;
    }
    break;
  default:
    cout << "Unknown type in DeathPacket received." << endl;
    break;
  }
  peer->ship->usePacket(packet);
  addToAllTCP(*packet, peer, players);
  addToAllTCP(*packet, peer, connecting);
}