//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be appreciated.

#include "Itana.h"
#include "Server.h"
#include "ItanaServer.h"
#include "Game.h"
#include "Parser.h"
#include "Base.h"
#include "Ship.h"
#include "ServerPrivate.h"

bool Server::checkForNewPlayers() {
  //Checks for new players, connects with player if a player is detected.
  NET_CONN* newClient = net_poll_listen(listen);
  if (newClient != NULL) {
    //We got a new player, set up connections
    NetPlayer* newPlayer = new NetPlayer();
    newPlayer->TCP = newClient;
    newPlayer->UDP = net_openchannel(netDriver, NULL);
    if (newPlayer->UDP == NULL) {
      //connect with client has failed
      cout << "Client connection failed to open UDP connect" << endl;
      newPlayer->shutDown();
      delete newPlayer;
      return false;
    }
    //send port number to client
    char* port = net_getlocaladdress(newPlayer->UDP);
    port = strchr(port, ':') + 1;
    if (net_send_rdm(newPlayer->TCP, port, strlen(port)+1)) {
      //connect with client has failed
      cout << "Client connection failed to open RDM connect" << endl;
      newPlayer->shutDown();
      delete newPlayer;
      return false;
    }
    dataOut += strlen(port);
    //Send id number to new client
    GreetPacket versionCheck;
    versionCheck.playerId = getNextId();
    int pos = versionCheck.createPacket(netbuf, 0);
    netbuf[pos++] = ENDOFPACKET;
    net_send_rdm(newPlayer->TCP, netbuf, pos); //send version packet now
    dataOut += pos;
    //Send current frame to new client
    newPlayer->TCPqueue.add(new FramePacket());
    //queue up packets to be sent to player
    //Send players, not including this one.
    int c, l;
    l = players.Length();
    players.SetToStart();
    for (c=0; c<l; c++) {
      newPlayer->TCPqueue.add(new PlayerPacket(players._GetNext()->data));
      newPlayer->TCPqueue.add(players._GetNext()->ship->makePacket());
      players._Advance();
    }
    LinkList<Entity>* oEnts = Game::getOrbitingEntities();
    oEnts->SetToStart();
    l = oEnts->Length();
    for (c=0; c<l; c++) {
      Entity* next = oEnts->_GetNext();
      if (next->isBase() || next->isRoid())
        newPlayer->TCPqueue.add(next->makePacket());
      oEnts->_Advance();
    }
    cout << "Client @" << net_getpeer(newPlayer->TCP) << " join initial contact successful to local port " << port << endl;
    connecting._MoveData(newPlayer);
  }
  return false;
}

bool Server::pollConnectingPlayers() {
  bool terminated = false;
  int l = connecting.Length();
  connecting.SetToStart();
  for (int c=0; c<l; c++) {
    terminated = false;
    NetPlayer* next = connecting._GetNext();
    int sent = next->sendTCPPacket(); //Send pending packets
    if (sent) {
      dataOut += sent;
      next->lastTime = Game::getFrame(); //timeout data
    }

    if (!next->gotData) {
      //Check for TCP data packet
      if (terminated = checkConnectingTCP(next)) {
        cout << " terminating client @" << net_getpeer(next->TCP) << endl;
        next->shutDown();
        connecting._DeleteThis();
      }
    } else {
      //Check for the UDP packet client sends after information is received
      if (terminated = checkConnectingUDP(next)) {
        //terminated here might be a normal termination
        connecting._DeleteThis();
      }
    }
    
    //Check for timeout -- if we stop sending data, client has stopped responding
    //since UDP packet should arrive quickly after data runs out.
    if (!terminated && (Game::getFrame() - next->lastTime) * 10 > TIMEOUT) {
      cout << next->data.getName() << " timed out while connecting." << endl;
      next->shutDown();
      terminated = true;
      connecting._DeleteThis();
    }

    if (!terminated)
      connecting._Advance();
  }
  return false;
}

bool Server::checkConnectingTCP(NetPlayer* next) {
  //return true if client was terminated.
  bool terminated = false;
  int recv = net_receive_rdm(next->TCP, netbuf, NETBUF_SIZE);
  if (recv < 0) {
    cout << "RDM recieve error for client @" << net_getpeer(next->TCP) << endl;
    terminated = true;
  } else if (recv > 0) {
    if (Packet::getNextType(netbuf, 0) != GREET) {
      cout << "Client sent wrong packet type" << endl;
      terminated = true;
    } else {
      next->gotData = true;
      //The following is OK since we checked for packet type before parsing.
      int currPos = 0;
      GreetPacket greet;
      currPos = greet.recvPacket(netbuf, currPos);
      if (greet.version != PROTOCOLVERSION) {
        cout << "Version mismatch: Client's version is " << int(greet.version) << " ours is " << int(PROTOCOLVERSION) << '.' << endl;
        terminated = true;
      } else {
        PlayerPacket data;
        currPos = data.recvPacket(netbuf, currPos);
        cout << "Adding player " << data.getName() << " to the world" << endl;
        if (next->initPlayerData(data)) {
          cout << "Error creating player data -- out of memory or client protocol error" << endl;
          terminated = true;
        } else {            
          //Send ship and base data to other players
          addToAllTCP(next->data, NULL, players);
          addToAllTCP(next->data, NULL, connecting);
          Packet* temp = next->ship->makePacket();
          addToAllTCP(*temp, NULL, players);
          addToAllTCP(*temp, NULL, connecting);
          delete temp;
          temp = next->base->makePacket();
          addToAllTCP(*temp, NULL, players);
          addToAllTCP(*temp, NULL, connecting);
          delete temp;
          
          //Send terminator packet to this player
          next->TCPqueue.add(new Packet()); //terminator
        }
      }
    }
  }
  return terminated;
}

bool Server::checkConnectingUDP(NetPlayer* next) {
  bool terminated = false;
  int recv = net_receive(next->UDP, netbuf, NETBUF_SIZE, netbuf2);
  if (recv < 0) {
    cout << "UDP recieve error for client @" << net_getpeer(next->TCP) << endl;
    cout << " terminating client @" << net_getpeer(next->TCP) << endl;
    next->shutDown();
    terminated = true;
  } else if (recv > 0) {
    //when we get the UDP client second stage complete
    terminated = true;
    if (net_assigntarget(next->UDP, netbuf2)) {
      cout << "Fatal UDP error (possibly libnet internal)" << endl;
      cout << "netbuf2: " << netbuf2 << endl;
      cout << " terminating client @" << net_getpeer(next->TCP) << endl;
      next->shutDown();
    } else {
      //Player is connected!
      next->lastTime = Game::getFrame(); //This way the player won't dropout
      cout << next->data.getName() << '@' << net_getpeer(next->TCP) << " connected." << endl;
      players._MoveData(next->makePartialClone());
    }
  }
  return terminated;
}