//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be appreciated.

#ifndef _Server_h_
#define _Server_h_

#include "Itana.h"
#include "Network.h"
#include "NetPlayer.h"

class Server : public Network {
public:
  Server();
  ~Server();

  PlayerId whoIsThis(void* other);
    //see Network.h
  const char* getName(PlayerId id);
    //Returns the player name associated with this PlayerId
  const char* getOurName() const;
    //Returns "Server"
  const NetPeer** getPeers();
    //For Console -- returns an NEWLY ALLOCATED array of NetPeer*
    //pointing to objects to display which won't be deleted.
    //The last pointer is NULL to signify the end of the array.

  void sendPacket(Packet* packet, bool reliable);
    //Sends a packet to all players excluding the one that sent it.
    //Network handles memory allocation of packet, and will delete it.

  bool doServer(int port); 
    //starts server and exits when server terminates.  If there is an error
    //lastError is filled and the calling function can print an error message.

  bool update();
    //returns true only on an unrecoverable error which would require
    //termination of the network connection

private:
  NetPlayer* findPlayer(PlayerId id);
  int getNextId(); //returns next available client ID
  //Functions below return true only on an unrecoverable error which
  //would require termination of the network connection
  bool checkForNewPlayers();
  bool pollConnectingPlayers();
  bool checkConnectingTCP(NetPlayer* next); //return true if client was terminated.
  bool checkConnectingUDP(NetPlayer* next);
  bool pollConnectedPlayers();
  bool handlePacket(Packet* next, NetPlayer* peer);
  //returns true if the player who sent this packet quit
  void handleShipPacket(ShipPacket* packet, NetPlayer* peer);
  void handleDynamicEntityPacket(DynamicEntityPacket* packet, NetPlayer* peer);
  void handlePlayerPartPacket(PlayerPartPacket* packet, NetPlayer* peer);
  void handleDeathPacket(DeathPacket* packet, NetPlayer* peer);    

  void addToAllTCP(const Packet& packet, NetPlayer* exclude, LinkList<NetPlayer>& theList);
  void addToAllUDP(const Packet& packet, NetPlayer* exclude, LinkList<NetPlayer>& theList);
  //Adds a packet to all players, with an optional pointer to an excluded
  //player, or NULL if none are to be excluded.

  bool checkInput(); //checks for server exit

  void shutDown(); //cleans everything up

  void generate(); //generates a new server game
  bool displayConnectInfo(const char* charPort);

  LinkList<NetPlayer> players;
  LinkList<NetPlayer> connecting;

  NET_CONN* listen;//connection we are listening on
};

#endif /* #ifndef _Server_h_ */
