//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be appreciated.

#ifndef _NetPlayer_h_
#define _NetPlayer_h_

#include "Itana.h"
#include "NetPeer.h"
class StatsPacket;

//The server uses the NetPlayer class
class NetPlayer : public NetPeer {
public:
  NetPlayer();
  ~NetPlayer();
  NetPlayer* makePartialClone() const;
    //makes a new NetPlayer, everything is copied but the queues
    //you must deallocate this object with delete

  void shutDown();  //closes sockets if they are not == NULL
  int getLatency(); //Returns latency from client in ms
  StatsPacket* getStats(); //CREATES a new StatsPacket based on this player's stats

  bool initPlayerData(const PlayerPacket& packet);
  //creates and binds a ship and base for the player and initalzes the player.
  //returns true on error

  int sendTCPPacket();
  int sendUDPPacket();
  //Creates an optimal packet if there is data and handles all sending to player.
  //Returns bytes of data sent, if any.

  int getNextPacket(char* buf, int bufSize);
  //Gets next packet, if there was one.  Netbuf needs to be large enough to hold a
  //UDP packet sized data (600+).  Returns -1 on error, or the number of bytes
  //received (note if there is no pending data, getNextPacket returns 0).

  NET_CONN*    TCP; //TCP connection to client
  LinkQueue<Packet> TCPqueue; //queue of reliable packets to send
  NET_CHANNEL* UDP; //UDP connection to client
  LinkQueue<Packet> UDPqueue; //queue of unreliable packets to send
  bool gotData;     //true if client has sent its PlayerData packet
  int lastPing;     //last ping sent, used to send more ping packets
  int lastTime;     //last response from the player, used to determine latency and dropout
  int lastPosUpdate;//last position update from player, used to discard old packets
private:
  char* tempBuf; //for RDM sending usage to hold a pending packet when buffer overflows
  int tempBufLen;//length of temporary RDM packet
};

#endif /* #ifndef _NetPlayer_h_ */
