//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be appreciated.

#include "ZylexBullet.h"
#include "Video.h"
#include "itanadat.h"
#include "EntityConsts.h"

ZylexBullet::ZylexBullet(const Point& p, const Vector& rel, double theta)
: Bullet(p, rel, theta, ID_ZYLEXBULLET) {
}

ZylexBullet::ZylexBullet() : Bullet( ID_ZYLEXBULLET ) {
}

void ZylexBullet::init(const Point& p, const Vector& rel, double theta) {
  Bullet::init(p, rel, theta, ID_ZYLEXBULLET);
}

void ZylexBullet::draw() {
  Video::drawSprite(GRFX_DAT_ZYLBULL_BMP, loc, scrLoc, radToFix(theta));
}
