//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#ifndef _VECTOR_H_
#define _VECTOR_H_

#include "Itana.h"
#include "Point.h"
#include "Rect.h"

class Vector {
public:
  Vector() : magx(0), magy(0), theta(0), mag(0) {}
  Vector(double magx2, double magy2) {initRect(magx2, magy2);}

  void initRect(double magx2, double magy2);
  void initPolar(double theta2, double mag2);

  double getMagx() const {return magx;}
  double getMagy() const {return magy;}
  double getTheta() const {return theta;}
  double getMag() const {return mag;}

  void rotate(double rotation);   //"turn" the vector
  void add(const Vector& other);  //Vector addition
  void add(double scalar);        //add to magnitude
  void clip(double max);          //clips mag to max
  //void clipTheta(double newTheta, double tolerance);
                                  //clips theta to newTheta if it is within tolerance
  void mult(double scalar);       //multiplies to total magnitude

  void addTo(Point& other) const {//Adds magx & magy to the Point
    other.x += magx;
    other.y += magy;
  }
  void addTo(Rect& other) const {
    other.x += magx;
    other.y += magy;
  }

protected:
  double magx, magy;
  double theta, mag;
private:
};

#endif