//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#ifndef _SOUND_H_
#define _SOUND_H_

#include "Itana.h"
class Point;

const int MAX_TRAX = 0;

class Sound {
public:
  static void init(DATAFILE* root);

  static void playSound(int idx, int vol = 255, int pan = 128, int freq = 1000);
  static void playMapSound(int idx, const Point& loc, int freq = 1000);  //panns to screen
  static void playRandomSound(int base, int num, int vol = 255, int pan = 128, int freq = 1000);
  static void playRandomMapSound(int base, int num, const Point& loc, int freq = 1000);
    //plays a sound from index base to base+num-1

  //Used to manage the looping engine sound.  high == true == afterburner
  //These remember settings so they can be called every frame but only keep
  //one sound playing correctly and adjust or stop it as needed
  static void engineOn(bool high);
  static void engineOff();

  static void playTrack(int track);
  static void playRandomTrack();
  static void stopMusic();

private:
  static DATAFILE* sounds; //sfx
  //static JGMOD* trax[];    //Music tracks

  static bool engine; //engine sound state
};

#endif