//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#include "Itana.h"
#include "Sound.h"
#include "itanadat.h"
#include "Video.h"
#include "Rect.h"
#include "Point.h"
#include "Prefs.h"

DATAFILE* Sound::sounds = NULL; //sfx
//JGMOD* Sound::trax[];    //Music tracks
bool Sound::engine = false;

//int play_sample(SAMPLE *spl, int vol, int pan, int freq, int loop);
//How far outside the view will a sound be played?
const double SOUND_BORDER = 128.0;
//proportion constant -- max vol div by max dist
const double SOUND_CONST = 255/1179.47785057626241123049561015614;
const int    SOUND_MIN = 64;

void Sound::init(DATAFILE* root) {
  sounds = (DATAFILE*) root[SFX_DAT].dat;
  set_volume(prefs->svol, -1);
}

void Sound::playSound(int idx, int vol, int pan, int freq) {
  play_sample((SAMPLE*)sounds[idx].dat, vol, pan, freq, 0);
}

void Sound::playMapSound(int idx, const Point& loc, int freq) {
  Rect view = Video::getView();
  view.x -= SOUND_BORDER;
  view.y -= SOUND_BORDER;
  view.w += SOUND_BORDER*2;
  view.h += SOUND_BORDER*2;
  if (view.isCollision(loc)) {
    int pan = (int)(255.0 * (loc.x - view.x) / view.w);
    int vol = 255 - (int)(view.getCenter().distTo(loc) * SOUND_CONST) + SOUND_MIN;
    if (vol > 255)
      vol = 255;
    play_sample((SAMPLE*)sounds[idx].dat, vol, pan, freq, 0);
  }
}

void Sound::playRandomSound(int base, int num, int vol, int pan, int freq) {
  playSound(base + getrnd(num), vol, pan, freq);
}

void Sound::playRandomMapSound(int base, int num, const Point& loc, int freq) {
  playMapSound(base + getrnd(num), loc, freq);
}

void Sound::engineOn(bool high) {
  int vol = 64; //normal engine sound
  if (high)
    vol = 255;  //afterburner volume

  if (engine)
    adjust_sample((SAMPLE*)sounds[SFX_DAT_ABURNER_WAV].dat, vol, 128, 1000, 1);
  else {
    play_sample((SAMPLE*)sounds[SFX_DAT_ABURNER_WAV].dat, vol, 128, 1000, 1);
    engine = true;
  }
}

void Sound::engineOff() {
  stop_sample((SAMPLE*)sounds[SFX_DAT_ABURNER_WAV].dat);
  engine = false;
}

void Sound::playTrack(int track) {
}

void Sound::playRandomTrack() {
}

void Sound::stopMusic() {
}