/***************************************************************************
                          Rect.h  -  description
                             -------------------
    begin                : Tue Dec 12 2000
    copyright            : (C) 2000 by Gillius
    email                : gillius@webzone.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be appreciated.

#ifndef _RECT_H_
#define _RECT_H_

#include "Itana.h"
#include "Point.h"

//Rectange class.  To be consistant with Allegro bitmap functions the corners
// are x, y, x+w-1, and y+h-1.  So a single pixel has w == h == 1.
class Rect {
public:
  double x, y, w, h;

  Rect() {}
  Rect(double x2, double y2, double w2, double h2) : x(x2), y(y2), w(w2), h(h2) {}

  void init(double x2, double y2, double w2, double h2) {
    x = x2; y = y2; w = w2; h = h2;
  }

  double getRight() const {  //inclusive point
    return x+w-1.0;
  }

  double getBottom() const { //inclusive point
    return y+h-1.0;
  }

  Point getCenter() const {
    return Point(x+w/2.0, y+h/2.0);
  }

  bool isCollision(const Point& other) const {
    return ((other.x <= x+w-1.0) && (other.y <= y+h-1.0) &&
      (other.x >= x) && (other.y >= y));
  }

  bool isCollision(const Rect& other) const {
    return ((other.x <= x+w-1.0) && (other.y <= y+h-1.0) &&
      (other.x+other.w-1.0 >= x) && (other.y+other.h-1.0 >= y));
  }

  double distTo(const Rect& other) const { //Finds distance based on midpoints
    return fabs(sqrt(sq((other.x+other.w/2.0)-(x+w/2.0)) + sq((other.y+other.h/2.0)-(y+h/2.0))));
  }

protected:
private:
};

#endif