//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#ifndef _RADAR_H_
#define _RADAR_H_

#include "Itana.h"
#include "Entity.h"

class Radar {
public:
  Radar();
  ~Radar();
  void init();

  void setCenter(const Point& loc);

  void input();
  void update();
  void draw(BITMAP* dest);

private:
  void render(BITMAP* bmp);
    //renders all entities onto one of the radar bitmaps
  void drawGrid(BITMAP* bmp);
    //draws the grid onto radar bmp
  void drawEntity(Entity* entity, BITMAP* bmp);
    //bmp will either be the small or large radar

  Point radarLoc;

  bool bigRadarOn;   //true if the big radar is to be displayed
  bool radarCleared; //true if the radar bitmap is clear
  bool bigRadarCleared;//true if the big radar bitmap is clear
  BITMAP* bigRadar;  //bitmap for the large radar on screen
  BITMAP* radar;     //radar area
};

#endif