//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be appreciated.

#ifndef _Parser_h_
#define _Parser_h_

#include "Itana.h"
#include "Rect.h"
#include "Vector.h"
#include "PacketConsts.h"

namespace Parser {
  //binary output function -- Intel format
  int makePoint(char* buf, int startPos, const Point& value);
  int makeVect(char* buf, int startPos, const Vector& value);
  int makeDouble(char* buf, int startPos, double value); //saves doubles as floats
  int makeString(char* buf, int startPos, const char* value); //leaves NULL in packet

  //binary input functions -- Intel format
  int parsePoint(const char* buf, int startPos, Point& value);
  int parseVect(const char* buf, int startPos, Vector& value);
  int parseDouble(const char* buf, int startPos, double& value); //reads floats as doubles
  int parseString(const char* buf, int startPos, char* value);
    //next object MUST be a string, because this will read to NULL.
    //string is copied into value

  //utility functions
  template <class T> static int makeDirect(char* buf, int startPos, const T& value) {
    memcpy((void*)&buf[startPos], (const void*)&value, sizeof(T));
    return (startPos + sizeof(T));
  }
  
  template <class T> static int parseDirect(const char* buf, int startPos, T& value) {
    memcpy((void*)&value, (const void*)&buf[startPos], sizeof(T));
    return (startPos + sizeof(T));
  }
};

#endif /* #ifndef _Parser_h_ */
