//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be appreciated.

#ifndef _Packet_h_
#define _Packet_h_

#include "Itana.h"
#include "PacketConsts.h"
#include "Rect.h"
#include "Vector.h"
#include "Point.h"

class Packet {
public:
  Packet();
  Packet(PacketType type2);
	virtual ~Packet() {}
  virtual Packet* makeClone() const;

  int getType() { return (int)type; }

  virtual int createPacket(char* buf, int startPos) const;
    //creates the packet and puts it in buf starting from startPos.  Buf is
    //allocated by caller and must be large enough to accept packet.  Returns
    //index of character immediately after appended data.
  virtual int recvPacket(const char* buf, int startPos);
    //receives and parses packet, filling fields, returns index of character
    //immediately after data.
  static int getNextType(const char* buf, int startPos);
    //discovers the next packet in the buf
  static Packet* parsePacket(const char* buf, int& startPos);
    //parses the next packet and returns a pointer to a newly allocated
    //packet object (delete with C++ delete command).  Returns NULL on error.
    //startPos is updated to be the index of the next unread byte.

  PlayerId playerId; //player or owner
  int frame; //timestamp
private:
  PacketType type;
};

class FramePacket : public Packet {
public:
  FramePacket() : Packet(FRAME) {}
	virtual ~FramePacket() {}
  virtual Packet* makeClone() const;
};

class ShipPacket : public Packet {
public:
  ShipPacket() : Packet(SHIP) {}
	virtual ~ShipPacket() {}
  virtual Packet* makeClone() const;

  int createPacket(char* buf, int startPos) const;
    //creates the packet and puts it in buf starting from startPos.  Buf is
    //allocated by caller and must be large enough to accept packet
  int recvPacket(const char* buf, int startPos);
    //receives and parses packet, filling fields, returns current position

  Actions actions;
  Vector vect;
  Point loc;
  float theta;
  float turret;
};

class DynamicEntityPacket : public Packet {
public:
  DynamicEntityPacket() : Packet(DYNAMICENTITY) {}
	virtual ~DynamicEntityPacket() {}
  virtual Packet* makeClone() const;

  int createPacket(char* buf, int startPos) const;
    //creates the packet and puts it in buf starting from startPos.  Buf is
    //allocated by caller and must be large enough to accept packet
  int recvPacket(const char* buf, int startPos);
    //receives and parses packet, filling fields, returns current position

  uchar objectId; //object type
  Vector vect;
  Point loc;
};

class PlayerMessagePacket : public Packet {
public:
  PlayerMessagePacket();
  PlayerMessagePacket(const PlayerMessagePacket& toCopy);
  virtual ~PlayerMessagePacket();
  virtual Packet* makeClone() const;

  int createPacket(char* buf, int startPos) const;
    //creates the packet and puts it in buf starting from startPos.  Buf is
    //allocated by caller and must be large enough to accept packet
  int recvPacket(const char* buf, int startPos);
    //receives and parses packet, filling fields, returns current position

  const char* getMessage();
  void setMessage(const char* newMessage);
  //deletes old memory and copies argument sent in

  PlayerMessagePacket& operator = (const PlayerMessagePacket& rhs);

private:
  char* message;
};

class PlayerPacket : public Packet {
public:
  PlayerPacket();
  PlayerPacket(const PlayerPacket& toCopy);
  virtual ~PlayerPacket();
  virtual Packet* makeClone() const;

  int createPacket(char* buf, int startPos) const;
    //creates the packet and puts it in buf starting from startPos.  Buf is
    //allocated by caller and must be large enough to accept packet
  int recvPacket(const char* buf, int startPos);
    //receives and parses packet, filling fields, returns current position

  uchar  shipType;
  ushort rate;   //max bandwith to send to this player
  uchar kills;
  uchar deaths;

  const char* getName() const;
  void setName(const char* newName);
  //deletes old memory and copies argument sent in

  PlayerPacket& operator = (const PlayerPacket& rhs);

private:
  char* name;
};

class PlayerPartPacket : public Packet {
public:
  PlayerPartPacket();
  virtual ~PlayerPartPacket();
  virtual Packet* makeClone() const;

  int createPacket(char* buf, int startPos) const;
    //creates the packet and puts it in buf starting from startPos.  Buf is
    //allocated by caller and must be large enough to accept packet
  int recvPacket(const char* buf, int startPos);
    //receives and parses packet, filling fields, returns current position

  bool status; //true if normal quit, false if dropout
};

class OrbitingEntityPacket : public Packet {
public:
  OrbitingEntityPacket() : Packet(ORBITINGENTITY) {}
	virtual ~OrbitingEntityPacket() {}
  virtual Packet* makeClone() const;

  int createPacket(char* buf, int startPos) const;
    //creates the packet and puts it in buf starting from startPos.  Buf is
    //allocated by caller and must be large enough to accept packet
  int recvPacket(const char* buf, int startPos);
    //receives and parses packet, filling fields, returns current position

  uchar objectId;
  double theta;
  double dist;
  ushort life;
};

class DamagePacket : public Packet {
  //DamagePacket represents damage done by a bullet.
public:
  DamagePacket() : Packet(DAMAGE) {}
	virtual ~DamagePacket() {}
  virtual Packet* makeClone() const;

  int createPacket(char* buf, int startPos) const;
    //creates the packet and puts it in buf starting from startPos.  Buf is
    //allocated by caller and must be large enough to accept packet
  int recvPacket(const char* buf, int startPos);
    //receives and parses packet, filling fields, returns current position

  PlayerId other; //player who inflicted damage
  uchar type;     //type of damage
  ushort life;
};

class DeathPacket : public Packet {
public:
  DeathPacket() : Packet(DEATH) {}
	virtual ~DeathPacket() {}
  virtual Packet* makeClone() const;

  int createPacket(char* buf, int startPos) const;
    //creates the packet and puts it in buf starting from startPos.  Buf is
    //allocated by caller and must be large enough to accept packet
  int recvPacket(const char* buf, int startPos);
    //receives and parses packet, filling fields, returns current position

  PlayerId other; //player who killed, if any
  uchar type; //type of death
};

class RespawnPacket : public Packet {
public:
  RespawnPacket() : Packet(RESPAWN) {}
	virtual ~RespawnPacket() {}
  virtual Packet* makeClone() const;
};

class StatsPacket : public Packet {
public:
  StatsPacket() : Packet(STATSPACKET) {}
	virtual ~StatsPacket() {}
  virtual Packet* makeClone() const;

  int createPacket(char* buf, int startPos) const;
    //creates the packet and puts it in buf starting from startPos.  Buf is
    //allocated by caller and must be large enough to accept packet
  int recvPacket(const char* buf, int startPos);
    //receives and parses packet, filling fields, returns current position

  ushort latency;
};

class PingPacket : public Packet {
public:
  PingPacket() : Packet(PING) {}
  virtual ~PingPacket() {}
  virtual Packet* makeClone() const;
};

class GreetPacket : public Packet {
public:
  GreetPacket() : Packet(GREET), version(PROTOCOLVERSION) {}
  virtual ~GreetPacket() {}
  virtual Packet* makeClone() const;

  int createPacket(char* buf, int startPos) const;
    //creates the packet and puts it in buf starting from startPos.  Buf is
    //allocated by caller and must be large enough to accept packet
  int recvPacket(const char* buf, int startPos);
    //receives and parses packet, filling fields, returns current position

  uchar version;
};

class ServerQuitPacket : public Packet {
public:
  ServerQuitPacket() : Packet(SERVERQUIT) {}
  virtual ~ServerQuitPacket() {}
  virtual Packet* makeClone() const;
};

#endif /* #ifndef _Packet_h_ */
