//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#ifndef _ORBITINGENTITY_H_
#define _ORBITINGENTITY_H_

#include "Itana.h"
#include "Entity.h"

class OrbitingEntity : public Entity {
public:
  OrbitingEntity() {}
  OrbitingEntity(const Rect& rect, double dist2, double theta2);

  void init(const Rect& rect, double dist2, double theta2);

  virtual void doCollision(Entity* other) {}
    //by default, OrbitingEntities are not affected in any way by collisions

  virtual void input() {}
    //since input() will never be used but can be called we will define
    //it as nothing here so child classes don't have to bother with it
  virtual bool update();
  virtual void draw() = 0;

protected:
  double dist;   //distance from origin (polar r)
  double dtheta; //rotational velocity
  double theta;  //polar theta
};

#endif
