//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#include "Itana.h"
#include "OrbitingEntity.h"

const double BASESPEED = 128*PI; //rotation speed at dist=1.0

OrbitingEntity::OrbitingEntity(const Rect& rect, double dist2, double theta2) {
  init(rect, dist2, theta2);
}

void OrbitingEntity::init(const Rect& rect, double dist2, double theta2) {
  Rect newRect(rect);
  dist = dist2;
  theta = theta2;
  dtheta = BASESPEED / dist / dist;
  newRect.x = dist * cos(theta);
  newRect.y = dist * sin(theta);
  Entity::init(newRect);
}

bool OrbitingEntity::update() {
  theta += dtheta;
  loc.x = dist * cos(theta);
  loc.y = dist * sin(theta);
  return false;
}