//Itana is copyright 2000 by Jason Winnebeck.  You may freely distribute this
//game in its original archive.  If us wish to use code from Itana feel free
//to do so.  If you do a mention in the credits or a mail to
//gillius@webzone.net would be apprciated.

#include "Itana.h"
#include "NetworkDrivers.h"

NetworkDrivers::NetworkDrivers() {
  names = NULL;
  drivers = net_driverlist_create();
  length = 0;
}

NetworkDrivers::~NetworkDrivers() {
  if (names)
    free(names);
}

void NetworkDrivers::addDriver(int driver) {
  //adds driver to detect list
  net_driverlist_add(drivers, driver);
}

void NetworkDrivers::setList(NET_DRIVERLIST driverList) {
  drivers = driverList;
}

void NetworkDrivers::detectDrivers() {
  //detects the drivers
  names = net_getdrivernames(net_initdrivers(drivers));
  //find number of drivers detected
  for (length=0; names[length].name; length++) {}
}

int NetworkDrivers::getLength() {
  //get number of drivers in this set
  return length;
}

int NetworkDrivers::getId(int idx) {
  //gets driver id given an index
  if (idx >= length)
    return NET_DRIVER_NONET;
  else
    return names[idx].num;
}

char* NetworkDrivers::getName(int idx) {
  //gets driver's name given an index
  if (idx >= length)
    return NULL;
  else
    return names[idx].name;
}